/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.utils.StringUtil;
import forestry.farming.gui.IFarmLedgerDelegate;
import net.minecraft.init.Items;

public class FarmLedger
extends Ledger {
    private final IFarmLedgerDelegate delegate;

    public FarmLedger(LedgerManager ledgerManager, IFarmLedgerDelegate delegate) {
        super(ledgerManager, "farm");
        this.delegate = delegate;
        int titleHeight = StringUtil.getLineHeight(this.maxTextWidth, this.getTooltip());
        this.maxHeight = titleHeight + 110;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        int xIcon = x + 3;
        int xBody = x + 10;
        int xHeader = x + 22;
        this.drawIcon(Items.water_bucket.getIconFromDamage(0), xIcon, y += 4);
        y += 4;
        if (!this.isFullyOpened()) {
            return;
        }
        y += this.drawHeader(StringUtil.localize("gui.hydration"), xHeader, y);
        y += 4;
        y += this.drawSubheader(StringUtil.localize("gui.hydr.heat") + ':', xBody, y);
        y += 3;
        y += this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationTempModifier()), xBody, y);
        y += 3;
        y += this.drawSubheader(StringUtil.localize("gui.hydr.humid") + ':', xBody, y);
        y += 3;
        y += this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationHumidModifier()), xBody, y);
        y += 3;
        y += this.drawSubheader(StringUtil.localize("gui.hydr.rainfall") + ':', xBody, y);
        y += 3;
        y += this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationRainfallModifier()) + " (" + this.delegate.getDrought() + " d)", xBody, y);
        y += 3;
        y += this.drawSubheader(StringUtil.localize("gui.hydr.overall") + ':', xBody, y);
        this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationModifier()), xBody, y += 3);
    }

    @Override
    public String getTooltip() {
        float hydrationModifier = this.delegate.getHydrationModifier();
        return StringUtil.floatAsPercent(hydrationModifier) + ' ' + StringUtil.localize("gui.hydration");
    }
}

