/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.CircuitBoard;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.config.ForestryItem;
import forestry.core.items.ItemForestryMultiPass;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemCircuitBoard
extends ItemForestryMultiPass {
    public ItemCircuitBoard() {
        this.setHasSubtypes(true);
    }

    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.BASIC, null, new ICircuit[0]));
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.ENHANCED, null, new ICircuit[0]));
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]));
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.INTRICATE, null, new ICircuit[0]));
    }

    public boolean getShareTag() {
        return true;
    }

    public int getColorFromItemStack(ItemStack itemstack, int pass) {
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[itemstack.getItemDamage()];
        if (pass == 0) {
            return type.getPrimaryColor();
        }
        return type.getSecondaryColor();
    }

    public String getUnlocalizedName(ItemStack stack) {
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[stack.getItemDamage()];
        return "item.for.circuitboard." + type.toString().toLowerCase(Locale.ENGLISH);
    }

    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        ICircuitBoard circuitboard = ChipsetManager.circuitRegistry.getCircuitboard(itemstack);
        if (circuitboard != null) {
            circuitboard.addTooltip(list);
        }
    }

    public static ItemStack createCircuitboard(EnumCircuitBoardType type, ICircuitLayout layout, ICircuit[] circuits) {
        ItemStack chipset = ForestryItem.circuitboards.getItemStack(1, type.ordinal());
        ItemCircuitBoard.saveChipset(chipset, new CircuitBoard(type, layout, circuits));
        return chipset;
    }

    private static void saveChipset(ItemStack itemstack, ICircuitBoard circuitboard) {
        if (circuitboard == null) {
            itemstack.setTagCompound(null);
            return;
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        circuitboard.writeToNBT(nbttagcompound);
        itemstack.setTagCompound(nbttagcompound);
    }
}

