/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.IHiveFrame;
import forestry.apiculture.inventory.InventoryApiary;
import forestry.apiculture.tiles.TileAbstractBeeHousing;
import forestry.apiculture.trigger.ApicultureTriggers;
import forestry.core.network.GuiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileApiary
extends TileAbstractBeeHousing {
    private static final IBeeModifier beeModifier = new ApiaryBeeModifier();
    private final IBeeListener beeListener = new ApiaryBeeListener(this);
    private final InventoryApiary inventory;

    public TileApiary() {
        super(GuiId.ApiaryGUI, "apiary");
        InventoryApiary apiaryInventory;
        this.inventory = apiaryInventory = new InventoryApiary(this);
        this.setInternalInventory(apiaryInventory);
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    public Collection<IBeeModifier> getBeeModifiers() {
        ArrayList<IBeeModifier> beeModifiers = new ArrayList<IBeeModifier>();
        beeModifiers.add(beeModifier);
        for (IHiveFrame frame : this.inventory.getFrames()) {
            beeModifiers.add(frame.getBeeModifier());
        }
        return beeModifiers;
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(ApicultureTriggers.missingQueen);
        res.add(ApicultureTriggers.missingDrone);
        res.add(ApicultureTriggers.noFrames);
        return res;
    }

    private static class ApiaryBeeListener
    extends DefaultBeeListener {
        private final TileApiary apiary;

        public ApiaryBeeListener(TileApiary apiary) {
            this.apiary = apiary;
        }

        @Override
        public void wearOutEquipment(int amount) {
            IBeekeepingMode beekeepingMode = BeeManager.beeRoot.getBeekeepingMode(this.apiary.getWorldObj());
            int wear = Math.round((float)amount * beekeepingMode.getWearModifier());
            IInventory framesInventory = this.apiary.inventory.getFrameInventory();
            for (int i = 0; i < framesInventory.getSizeInventory(); ++i) {
                Item hiveFrameItem;
                ItemStack hiveFrameStack = framesInventory.getStackInSlot(i);
                if (hiveFrameStack == null || !((hiveFrameItem = hiveFrameStack.getItem()) instanceof IHiveFrame)) continue;
                IHiveFrame hiveFrame = (IHiveFrame)hiveFrameItem;
                ItemStack queenStack = this.apiary.getBeeInventory().getQueen();
                IBee queen = BeeManager.beeRoot.getMember(queenStack);
                ItemStack usedFrame = hiveFrame.frameUsed(this.apiary, hiveFrameStack, queen, wear);
                framesInventory.setInventorySlotContents(i, usedFrame);
            }
        }
    }

    private static class ApiaryBeeModifier
    extends DefaultBeeModifier {
        private ApiaryBeeModifier() {
        }

        @Override
        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return 0.1f;
        }
    }
}

