/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.gui.IGuiBeeHousingInventory;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.network.IStreamableGui;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.TileBase;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class TileAbstractBeeHousing
extends TileBase
implements IBeeHousing,
IClimatised,
IGuiBeeHousingInventory,
IStreamableGui {
    private final IBeekeepingLogic beeLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
    private BiomeGenBase cachedBiome;
    private int breedingProgressPercent = 0;

    protected TileAbstractBeeHousing(GuiId guiId, String hintKey) {
        super(guiId, hintKey);
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.beeLogic.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.beeLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public Packet getDescriptionPacket() {
        this.beeLogic.syncToClient();
        return super.getDescriptionPacket();
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        return this.getBiome().getFloatTemperature(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().rainfall;
    }

    @Override
    public void updateClientSide() {
        if (this.beeLogic.canDoBeeFX() && this.updateOnInterval(4)) {
            this.beeLogic.doBeeFX();
            if (this.updateOnInterval(50)) {
                TileAbstractBeeHousing.doPollenFX(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    public static void doPollenFX(World world, double xCoord, double yCoord, double zCoord) {
        double fxX = xCoord + 0.5;
        double fxY = yCoord + 0.25;
        double fxZ = zCoord + 0.5;
        float distanceFromCenter = 0.6f;
        float leftRightSpreadFromCenter = distanceFromCenter * (world.rand.nextFloat() - 0.5f);
        float upSpread = world.rand.nextFloat() * 6.0f / 16.0f;
        Proxies.render.addEntitySwarmFX(world, fxX - (double)distanceFromCenter, fxY += (double)upSpread, fxZ + (double)leftRightSpreadFromCenter);
        Proxies.render.addEntitySwarmFX(world, fxX + (double)distanceFromCenter, fxY, fxZ + (double)leftRightSpreadFromCenter);
        Proxies.render.addEntitySwarmFX(world, fxX + (double)leftRightSpreadFromCenter, fxY, fxZ - (double)distanceFromCenter);
        Proxies.render.addEntitySwarmFX(world, fxX + (double)leftRightSpreadFromCenter, fxY, fxZ + (double)distanceFromCenter);
    }

    @Override
    public void updateServerSide() {
        if (this.beeLogic.canWork()) {
            this.beeLogic.doWork();
        }
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.beeLogic.getBeeProgressPercent());
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.breedingProgressPercent = data.readVarInt();
    }

    @Override
    public BiomeGenBase getBiome() {
        if (this.cachedBiome == null) {
            this.cachedBiome = this.worldObj.getBiomeGenForCoordsBody(this.xCoord, this.zCoord);
        }
        return this.cachedBiome;
    }

    @Override
    public int getBlockLightValue() {
        return this.worldObj.getBlockLightValue(this.xCoord, this.yCoord + 1, this.zCoord);
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.worldObj.canBlockSeeTheSky(this.xCoord, this.yCoord + 1, this.zCoord);
    }

    @Override
    public GameProfile getOwner() {
        return this.getAccessHandler().getOwner();
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        return Vec3.createVectorHelper((double)((double)this.xCoord + 0.5), (double)((double)this.yCoord + 0.5), (double)((double)this.zCoord + 0.5));
    }
}

