/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.apiculture.gui.IGuiBeeHousingInventory;
import forestry.apiculture.network.PacketBeeLogicEntityRequest;
import forestry.apiculture.tiles.TileAbstractBeeHousing;
import forestry.apiculture.tiles.TileBeehouse;
import forestry.core.access.AccessHandler;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gui.IHintSource;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.network.IStreamableGui;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.utils.InventoryUtil;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

public class EntityMinecartBeehouse
extends EntityMinecartContainer
implements IBeeHousing,
IFilterSlotDelegate,
IGuiBeeHousingInventory,
IStreamableGui,
IRestrictedAccess,
IClimatised,
IHintSource {
    private static final Random random = new Random();
    private static final int beeFXInterval = 4;
    private static final int pollenFXInterval = 50;
    private final int beeFXTime = random.nextInt(4);
    private final int pollenFXTime = random.nextInt(50);
    private static final Iterable<IBeeModifier> beeModifiers = ImmutableList.of((Object)new TileBeehouse.BeehouseBeeModifier());
    private static final Iterable<IBeeListener> beeListeners = ImmutableList.of((Object)new DefaultBeeListener());
    private final IBeekeepingLogic beeLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
    private final IErrorLogic errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
    private final BeeCartInventory beeInventory = new BeeCartInventory(this);
    private final AccessHandler accessHandler = new AccessHandler(this);
    private int breedingProgressPercent = 0;
    private boolean needsActiveUpdate = true;

    public EntityMinecartBeehouse(World world) {
        super(world);
        this.setHasDisplayTile(true);
    }

    public EntityMinecartBeehouse(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.setHasDisplayTile(true);
    }

    public final boolean interactFirst(EntityPlayer player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player))) {
            return true;
        }
        if (!this.worldObj.isRemote) {
            player.openGui(ForestryAPI.instance, GuiId.MinecartBeehouseGUI.ordinal(), this.worldObj, this.getEntityId(), -1, 0);
        }
        return true;
    }

    public void setOwner(GameProfile owner) {
        this.accessHandler.setOwner(owner);
    }

    public int getMinecartType() {
        return -1;
    }

    public int getSizeInventory() {
        return 9;
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return beeModifiers;
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return beeListeners;
    }

    @Override
    public BeeCartInventory getBeeInventory() {
        return this.beeInventory;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), (int)this.posX, (int)this.posY, (int)this.posZ);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getBiome().rainfall);
    }

    @Override
    public float getExactTemperature() {
        return this.getBiome().temperature;
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().rainfall;
    }

    @Override
    public int getBlockLightValue() {
        return this.worldObj.getBlockLightValue((int)this.posX, (int)this.posY, (int)this.posZ);
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.worldObj.canBlockSeeTheSky((int)this.posX, (int)this.posY, (int)this.posZ);
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.worldObj.getBiomeGenForCoords((int)this.posX, (int)this.posZ);
    }

    @Override
    public GameProfile getOwner() {
        return this.accessHandler.getOwner();
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates((int)this.posX, (int)this.posY, (int)this.posZ);
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        return Vec3.createVectorHelper((double)this.posX, (double)(this.posY + 0.25), (double)this.posZ);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.beeLogic.getBeeProgressPercent());
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.breedingProgressPercent = data.readVarInt();
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote) {
            if (this.beeLogic.canWork()) {
                this.beeLogic.doWork();
            }
        } else {
            if (this.needsActiveUpdate) {
                PacketBeeLogicEntityRequest packet = new PacketBeeLogicEntityRequest((Entity)this);
                Proxies.net.sendToServer(packet);
                this.needsActiveUpdate = false;
            }
            if (this.beeLogic.canDoBeeFX()) {
                if (this.worldObj.getTotalWorldTime() % 4L == (long)this.beeFXTime) {
                    this.beeLogic.doBeeFX();
                }
                if (this.worldObj.getTotalWorldTime() % 50L == (long)this.pollenFXTime) {
                    TileAbstractBeeHousing.doPollenFX(this.worldObj, this.posX - 0.5, this.posY - 0.1, this.posZ - 0.5);
                }
            }
        }
    }

    protected void readEntityFromNBT(NBTTagCompound nbtTagCompound) {
        super.readEntityFromNBT(nbtTagCompound);
        this.beeLogic.readFromNBT(nbtTagCompound);
        this.accessHandler.readFromNBT(nbtTagCompound);
    }

    protected void writeEntityToNBT(NBTTagCompound nbtTagCompound) {
        super.writeEntityToNBT(nbtTagCompound);
        this.beeLogic.writeToNBT(nbtTagCompound);
        this.accessHandler.writeToNBT(nbtTagCompound);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        EnumBeeType beeType = BeeManager.beeRoot.getType(itemStack);
        if (slotIndex == 0) {
            return beeType == EnumBeeType.QUEEN || beeType == EnumBeeType.PRINCESS;
        }
        if (slotIndex == 1) {
            return beeType == EnumBeeType.DRONE;
        }
        return false;
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return false;
    }

    @Override
    public String getUnlocalizedTitle() {
        return "entity." + this.getEntityString() + ".name";
    }

    public boolean canBeRidden() {
        return false;
    }

    public Block func_145820_n() {
        return ForestryBlock.apiculture.block();
    }

    public int getDisplayTileData() {
        return 2;
    }

    public void killMinecart(DamageSource damageSource) {
        super.killMinecart(damageSource);
        if (!damageSource.isExplosion()) {
            this.entityDropItem(new ItemStack(this.func_145820_n(), 1, this.getDisplayTileData()), 0.0f);
        }
    }

    public void setDead() {
        if (this.worldObj.isRemote) {
            for (int slot = 0; slot < this.getSizeInventory(); ++slot) {
                this.setInventorySlotContents(slot, null);
            }
        }
        super.setDead();
    }

    public ItemStack getCartItem() {
        return ForestryItem.minecartBeehouse.getItemStack();
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemStack) {
        return this.canSlotAccept(slot, itemStack);
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return this.accessHandler;
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"bee.house");
    }

    private static class BeeCartInventory
    implements IBeeHousingInventory {
        public static final int SLOT_QUEEN = 0;
        public static final int SLOT_DRONE = 1;
        public static final int SLOT_PRODUCT_1 = 2;
        public static final int SLOT_PRODUCT_COUNT = 7;
        private final EntityMinecartBeehouse cart;

        public BeeCartInventory(EntityMinecartBeehouse cart) {
            this.cart = cart;
        }

        @Override
        public final ItemStack getQueen() {
            return this.cart.getStackInSlot(0);
        }

        @Override
        public final ItemStack getDrone() {
            return this.cart.getStackInSlot(1);
        }

        @Override
        public final void setQueen(ItemStack itemstack) {
            this.cart.setInventorySlotContents(0, itemstack);
        }

        @Override
        public final void setDrone(ItemStack itemstack) {
            this.cart.setInventorySlotContents(1, itemstack);
        }

        @Override
        public final boolean addProduct(ItemStack product, boolean all) {
            return InventoryUtil.tryAddStack(this.cart, product, 2, 7, all, true);
        }
    }
}

