/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.GameMode;
import forestry.core.fluids.Fluids;
import forestry.core.utils.ModUtil;
import forestry.farming.logic.FarmableBasicAgricraft;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginManager;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="AgriCraft", name="AgriCraft", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.agricraft.description")
public class PluginAgriCraft
extends ForestryPlugin {
    private static final String AgriCraft = "AgriCraft";

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(AgriCraft);
    }

    @Override
    public String getFailMessage() {
        return "AgriCraft not found";
    }

    @Override
    protected void registerRecipes() {
        ImmutableList seeds = ImmutableList.of((Object)"Allium", (Object)"Dandelion", (Object)"Daisy", (Object)"TulipRed", (Object)"TulipPink", (Object)"TulipOrange", (Object)"TulipWhite", (Object)"Sugarcane", (Object)"Cactus", (Object)"Carrot", (Object)"Potato", (Object)"Poppy", (Object[])new String[]{"Orchid", "ShroomRed", "ShroomBrown", "BotaniaCyan", "BotaniaLime", "BotaniaRed", "BotaniaLightGray", "BotaniaOrange", "BotaniaBlack", "BotaniaLightBlue", "BotaniaPink", "BotaniaWhite", "BotaniaGreen", "BotaniaYellow", "BotaniaMagenta", "BotaniaBrown", "BotaniaPurple", "BotaniaBlue", "BotaniaGray"});
        int seedamount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed");
        for (String seedName : seeds) {
            ItemStack seed = GameRegistry.findItemStack((String)AgriCraft, (String)("seed" + seedName), (int)1);
            if (seed == null) continue;
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{seed}, Fluids.SEEDOIL.getFluid(seedamount));
        }
        Block cropBlock = GameRegistry.findBlock((String)AgriCraft, (String)"crops");
        if (cropBlock != null && PluginManager.Module.FARMING.isEnabled()) {
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicAgricraft(cropBlock, 7));
        }
    }
}

