/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.IRenderableTile;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.SlotUtil;
import forestry.factory.recipes.MoistenerRecipeManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileMoistener
extends TileBase
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler,
IRenderableTile {
    private static final short SLOT_STASH_1 = 0;
    private static final short SLOT_STASH_COUNT = 6;
    private static final short SLOT_RESERVOIR_1 = 6;
    private static final short SLOT_RESERVOIR_COUNT = 3;
    private static final short SLOT_WORKING = 9;
    private static final short SLOT_PRODUCT = 10;
    private static final short SLOT_RESOURCE = 11;
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private IMoistenerRecipe currentRecipe;
    private int burnTime = 0;
    private int totalTime = 0;
    private int productionTime = 0;
    private int timePerItem = 0;
    private ItemStack currentProduct;
    private ItemStack pendingProduct;

    public TileMoistener() {
        this.setInternalInventory(new MoistenerInventoryAdapter(this));
        this.setHints(Config.hints.get("moistener"));
        this.resourceTank = new FilteredTank(10000, FluidRegistry.WATER);
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.MoistenerGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompoundP;
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("BurnTime", this.burnTime);
        nbttagcompound.setInteger("TotalTime", this.totalTime);
        nbttagcompound.setInteger("ProductionTime", this.productionTime);
        this.tankManager.writeToNBT(nbttagcompound);
        if (this.pendingProduct != null) {
            nbttagcompoundP = new NBTTagCompound();
            this.pendingProduct.writeToNBT(nbttagcompoundP);
            nbttagcompound.setTag("PendingProduct", (NBTBase)nbttagcompoundP);
        }
        if (this.currentProduct != null) {
            nbttagcompoundP = new NBTTagCompound();
            this.currentProduct.writeToNBT(nbttagcompoundP);
            nbttagcompound.setTag("CurrentProduct", (NBTBase)nbttagcompoundP);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompoundP;
        super.readFromNBT(nbttagcompound);
        this.burnTime = nbttagcompound.getInteger("BurnTime");
        this.totalTime = nbttagcompound.getInteger("TotalTime");
        this.productionTime = nbttagcompound.getInteger("ProductionTime");
        this.tankManager.readFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("PendingProduct")) {
            nbttagcompoundP = nbttagcompound.getCompoundTag("PendingProduct");
            this.pendingProduct = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompoundP);
        }
        if (nbttagcompound.hasKey("CurrentProduct")) {
            nbttagcompoundP = nbttagcompound.getCompoundTag("CurrentProduct");
            this.currentProduct = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompoundP);
        }
        this.checkRecipe();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        boolean gloomy;
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 10);
        }
        int lightvalue = this.worldObj.getBlockLightValue(this.xCoord, this.yCoord + 1, this.zCoord);
        IErrorLogic errorLogic = this.getErrorLogic();
        if (errorLogic.setCondition(!(gloomy = lightvalue <= 11), EnumErrorCode.NOTGLOOMY)) {
            return;
        }
        int speed = lightvalue >= 9 ? 1 : (lightvalue >= 7 ? 2 : (lightvalue >= 5 ? 3 : 4));
        if (this.burnTime > 0 && this.pendingProduct == null) {
            boolean hasLiquid = this.resourceTank.getFluidAmount() > 0;
            if (errorLogic.setCondition(!hasLiquid, EnumErrorCode.NORESOURCE)) {
                return;
            }
            this.checkRecipe();
            if (this.currentRecipe == null) {
                return;
            }
            this.resourceTank.drain(1, true);
            this.burnTime -= speed;
            this.productionTime -= speed;
            if (this.productionTime <= 0) {
                this.pendingProduct = this.currentProduct;
                this.decrStackSize(11, 1);
                this.resetRecipe();
                this.tryAddPending();
            }
        } else if (this.pendingProduct != null) {
            this.tryAddPending();
        } else if (this.rotateWorkingSlot()) {
            this.checkRecipe();
            if (this.getStackInSlot(9) == null) {
                return;
            }
            if (FuelManager.moistenerResource.containsKey(this.getStackInSlot(9))) {
                MoistenerFuel res = FuelManager.moistenerResource.get(this.getStackInSlot(9));
                this.burnTime = this.totalTime = res.moistenerValue;
            }
        } else {
            this.rotateReservoir();
        }
        errorLogic.setCondition(this.currentRecipe == null, EnumErrorCode.NORECIPE);
    }

    private boolean tryAddPending() {
        if (this.pendingProduct == null) {
            return false;
        }
        boolean added = InventoryUtil.tryAddStack((IInventory)this, this.pendingProduct, 10, 1, true);
        this.getErrorLogic().setCondition(!added, EnumErrorCode.NOSPACE);
        if (added) {
            this.pendingProduct = null;
        }
        return added;
    }

    public void checkRecipe() {
        IMoistenerRecipe sameRec = MoistenerRecipeManager.findMatchingRecipe(this.getInternalInventory().getStackInSlot(11));
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
        this.getErrorLogic().setCondition(this.currentRecipe == null, EnumErrorCode.NORECIPE);
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.currentProduct = null;
            this.productionTime = 0;
            this.timePerItem = 0;
        } else {
            this.currentProduct = this.currentRecipe.getProduct();
            this.productionTime = this.currentRecipe.getTimePerItem();
            this.timePerItem = this.currentRecipe.getTimePerItem();
        }
    }

    private int getFreeSlot(ItemStack deposit, int startSlot, int endSlot, boolean emptyOnly) {
        int slot = -1;
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack slotStack = this.getStackInSlot(i);
            if (slotStack == null) {
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (emptyOnly || !slotStack.isItemEqual(deposit) || slotStack.stackSize >= slotStack.getMaxStackSize()) continue;
            slot = i;
        }
        return slot;
    }

    private int getFreeStashSlot(ItemStack deposit, boolean emptyOnly) {
        return this.getFreeSlot(deposit, 0, 6, emptyOnly);
    }

    private int getFreeReservoirSlot(ItemStack deposit) {
        return this.getFreeSlot(deposit, 6, 9, false);
    }

    private int getNextResourceSlot(int startSlot, int endSlot) {
        int stage = -1;
        int resourceSlot = -1;
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = startSlot; i < endSlot; ++i) {
            ItemStack slotStack = inventory.getStackInSlot(i);
            if (slotStack == null || !FuelManager.moistenerResource.containsKey(slotStack)) continue;
            MoistenerFuel res = FuelManager.moistenerResource.get(slotStack);
            if (stage >= 0 && res.stage >= stage) continue;
            stage = res.stage;
            resourceSlot = i;
        }
        return resourceSlot;
    }

    private boolean rotateWorkingSlot() {
        IErrorLogic errorLogic = this.getErrorLogic();
        if (this.getStackInSlot(9) != null) {
            ItemStack deposit;
            if (FuelManager.moistenerResource.containsKey(this.getStackInSlot(9))) {
                MoistenerFuel res = FuelManager.moistenerResource.get(this.getStackInSlot(9));
                deposit = res.product.copy();
            } else {
                deposit = this.getStackInSlot(9).copy();
            }
            int targetSlot = this.getFreeReservoirSlot(deposit);
            if (errorLogic.setCondition(targetSlot < 0, EnumErrorCode.NOSPACE)) {
                return false;
            }
            if (this.getStackInSlot(targetSlot) == null) {
                this.setInventorySlotContents(targetSlot, deposit);
            } else {
                ++this.getStackInSlot((int)targetSlot).stackSize;
            }
            this.decrStackSize(9, 1);
        }
        if (this.getStackInSlot(9) != null) {
            return true;
        }
        int resourceSlot = this.getNextResourceSlot(6, 9);
        if (errorLogic.setCondition(resourceSlot < 0, EnumErrorCode.NORESOURCE)) {
            return false;
        }
        this.setInventorySlotContents(9, this.decrStackSize(resourceSlot, 1));
        return true;
    }

    private void rotateReservoir() {
        int targetSlot;
        int resourceSlot;
        ArrayList<Integer> slotsToShift = new ArrayList<Integer>();
        for (int i = 6; i < 9; ++i) {
            if (this.getStackInSlot(i) == null || FuelManager.moistenerResource.containsKey(this.getStackInSlot(i))) continue;
            slotsToShift.add(i);
        }
        int shiftedSlots = 0;
        Iterator i$ = slotsToShift.iterator();
        while (i$.hasNext()) {
            int slot = (Integer)i$.next();
            ItemStack slotStack = this.getStackInSlot(slot);
            int targetSlot2 = this.getFreeStashSlot(slotStack, true);
            if (targetSlot2 < 0) continue;
            this.setInventorySlotContents(targetSlot2, slotStack);
            this.setInventorySlotContents(slot, null);
            ++shiftedSlots;
        }
        for (int i = 0; i < (slotsToShift.size() > 0 ? shiftedSlots : 2) && (resourceSlot = this.getNextResourceSlot(0, 6)) >= 0 && (targetSlot = this.getFreeReservoirSlot(this.getStackInSlot(resourceSlot))) >= 0; ++i) {
            if (this.getStackInSlot(targetSlot) == null) {
                this.setInventorySlotContents(targetSlot, this.getStackInSlot(resourceSlot));
                this.setInventorySlotContents(resourceSlot, null);
                continue;
            }
            ItemStackUtil.mergeStacks(this.getStackInSlot(resourceSlot), this.getStackInSlot(targetSlot));
            if (this.getStackInSlot(resourceSlot) == null || this.getStackInSlot((int)resourceSlot).stackSize > 0) continue;
            this.setInventorySlotContents(resourceSlot, null);
        }
    }

    public boolean isWorking() {
        return this.burnTime > 0 && this.resourceTank.getFluidAmount() > 0;
    }

    public boolean hasFuelMin(float percentage) {
        int max = 0;
        int avail = 0;
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 0; i < 6; ++i) {
            if (inventory.getStackInSlot(i) == null) {
                max += 64;
                continue;
            }
            if (!FuelManager.moistenerResource.containsKey(inventory.getStackInSlot(i))) continue;
            MoistenerFuel res = FuelManager.moistenerResource.get(inventory.getStackInSlot(i));
            if (!res.item.isItemEqual(inventory.getStackInSlot(i))) continue;
            max += 64;
            avail += inventory.getStackInSlot((int)i).stackSize;
        }
        return (float)avail / (float)max > percentage;
    }

    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(11) == null) {
            return false;
        }
        return (float)inventory.getStackInSlot((int)11).stackSize / (float)inventory.getStackInSlot(11).getMaxStackSize() > percentage;
    }

    public boolean isProducing() {
        return this.productionTime > 0;
    }

    public int getProductionProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return 0;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public int getConsumptionProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.productionTime = j;
                break;
            }
            case 3: {
                this.timePerItem = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.sendProgressBarUpdate(container, 0, this.burnTime);
        iCrafting.sendProgressBarUpdate(container, 1, this.totalTime);
        iCrafting.sendProgressBarUpdate(container, 2, this.productionTime);
        iCrafting.sendProgressBarUpdate(container, 3, this.timePerItem);
    }

    private static class MoistenerInventoryAdapter
    extends TileInventoryAdapter<TileMoistener> {
        public MoistenerInventoryAdapter(TileMoistener moistener) {
            super(moistener, 12, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 11) {
                return MoistenerRecipeManager.isResource(itemStack);
            }
            if (SlotUtil.isSlotInRange(slotIndex, 0, 6)) {
                return FuelManager.moistenerResource.containsKey(itemStack);
            }
            if (slotIndex == 10) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((TileMoistener)this.tile).resourceTank.accepts(fluid);
            }
            return false;
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            if (slotIndex == 10) {
                return true;
            }
            if (SlotUtil.isSlotInRange(slotIndex, 0, 9)) {
                return !FuelManager.moistenerResource.containsKey(itemstack);
            }
            return false;
        }
    }
}

