/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import forestry.core.circuits.ISocketable;
import forestry.core.inventory.filters.ArrayStackFilter;
import forestry.core.inventory.filters.IStackFilter;
import forestry.core.inventory.filters.StackFilter;
import forestry.core.inventory.manipulators.InventoryManipulator;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryCopy;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.inventory.wrappers.SidedInventoryMapper;
import forestry.core.tiles.AdjacentTileCache;
import forestry.core.utils.ItemStackUtil;
import forestry.plugins.PluginManager;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public abstract class InventoryUtil {
    public static IInventory getInventory(IInventory inv, ForgeDirection side) {
        if (inv == null) {
            return null;
        }
        if (inv instanceof ISidedInventory) {
            inv = new SidedInventoryMapper((ISidedInventory)inv, side);
        }
        return inv;
    }

    public static ItemStack depleteItem(ItemStack stack) {
        if (stack.stackSize == 1) {
            return stack.getItem().getContainerItem(stack);
        }
        stack.splitStack(1);
        return stack;
    }

    public static boolean isWildcard(ItemStack stack) {
        return InventoryUtil.isWildcard(stack.getItemDamage());
    }

    public static boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }

    public static boolean isItemEqualStrict(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getItem() != b.getItem()) {
            return false;
        }
        if (a.stackSize != b.stackSize) {
            return false;
        }
        if (a.getItemDamage() != b.getItemDamage()) {
            return false;
        }
        return a.stackTagCompound == null || a.stackTagCompound.equals((Object)b.stackTagCompound);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b) {
        return InventoryUtil.isItemEqual(a, b, true, true);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getItem() != b.getItem()) {
            return false;
        }
        if (matchNBT && !ItemStack.areItemStackTagsEqual((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        if (matchDamage && a.getHasSubtypes()) {
            if (InventoryUtil.isWildcard(a) || InventoryUtil.isWildcard(b)) {
                return true;
            }
            if (a.getItemDamage() != b.getItemDamage()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isItemEqual(ItemStack stack, ItemStack ... matches) {
        for (ItemStack match : matches) {
            if (!InventoryUtil.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack moveItemStack(ItemStack stack, IInventory dest) {
        InventoryManipulator im = InventoryManipulator.get(dest);
        return im.addStack(stack);
    }

    public static boolean moveItemStack(IInventory source, IInventory dest) {
        InventoryManipulator im = InventoryManipulator.get(dest);
        for (IInvSlot slot : InventoryIterator.getIterable(source)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            ItemStack remainder = im.addStack(stack);
            slot.setStackInSlot(remainder);
            return !InventoryUtil.isItemEqualStrict(stack, remainder);
        }
        return false;
    }

    public static boolean moveItemStack(IInventory source, Iterable<IInventory> destinations) {
        for (IInventory dest : destinations) {
            if (!InventoryUtil.moveItemStack(source, dest)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack removeOneItem(IInventory inv) {
        return InventoryUtil.removeOneItem(inv, StackFilter.ALL);
    }

    public static ItemStack removeOneItem(IInventory inv, ItemStack ... filter) {
        return InventoryUtil.removeOneItem(inv, new ArrayStackFilter(filter));
    }

    public static ItemStack removeOneItem(IInventory inv, IStackFilter filter) {
        InventoryManipulator im = InventoryManipulator.get(inv);
        return im.removeItem(filter);
    }

    public static boolean moveOneItemToPipe(IInventory source, AdjacentTileCache tileCache) {
        return InventoryUtil.moveOneItemToPipe(source, tileCache, ForgeDirection.VALID_DIRECTIONS);
    }

    public static boolean moveOneItemToPipe(IInventory source, AdjacentTileCache tileCache, ForgeDirection[] directions) {
        if (PluginManager.Module.BUILDCRAFT_TRANSPORT.isEnabled()) {
            return InventoryUtil.internal_moveOneItemToPipe(source, tileCache, directions);
        }
        return false;
    }

    @Optional.Method(modid="BuildCraftAPI|transport")
    private static boolean internal_moveOneItemToPipe(IInventory source, AdjacentTileCache tileCache, ForgeDirection[] directions) {
        InventoryCopy invClone = new InventoryCopy(source);
        ItemStack stackToMove = InventoryUtil.removeOneItem(invClone);
        if (stackToMove == null) {
            return false;
        }
        if (stackToMove.stackSize <= 0) {
            return false;
        }
        ArrayList<AbstractMap.SimpleEntry<ForgeDirection, IPipeTile>> pipes = new ArrayList<AbstractMap.SimpleEntry<ForgeDirection, IPipeTile>>();
        boolean foundPipe = false;
        for (ForgeDirection side : directions) {
            IPipeTile pipe;
            TileEntity tile = tileCache.getTileOnSide(side);
            if (!(tile instanceof IPipeTile) || (pipe = (IPipeTile)tile).getPipeType() != IPipeTile.PipeType.ITEM || !pipe.isPipeConnected(side.getOpposite())) continue;
            pipes.add(new AbstractMap.SimpleEntry<ForgeDirection, IPipeTile>(side, pipe));
            foundPipe = true;
        }
        if (!foundPipe) {
            return false;
        }
        int choice = tileCache.getSource().getWorldObj().rand.nextInt(pipes.size());
        Map.Entry pipe = (Map.Entry)pipes.get(choice);
        if (((IPipeTile)pipe.getValue()).injectItem(stackToMove, false, ((ForgeDirection)pipe.getKey()).getOpposite(), null) > 0 && InventoryUtil.removeOneItem(source, stackToMove) != null) {
            ((IPipeTile)pipe.getValue()).injectItem(stackToMove, true, ((ForgeDirection)pipe.getKey()).getOpposite(), null);
            return true;
        }
        return false;
    }

    public static boolean removeSets(IInventory inventory, int count, ItemStack[] set, EntityPlayer player, boolean stowContainer, boolean oreDictionary, boolean craftingTools, boolean doRemove) {
        ItemStack[] stock = InventoryUtil.getStacks(inventory);
        if (doRemove) {
            ItemStack[] removed = InventoryUtil.removeSets(inventory, count, set, player, stowContainer, oreDictionary, craftingTools);
            return removed != null && removed.length >= count;
        }
        return ItemStackUtil.containsSets(set, stock, oreDictionary, craftingTools) >= count;
    }

    public static ItemStack[] removeSets(IInventory inventory, int count, ItemStack[] set, EntityPlayer player, boolean stowContainer, boolean oreDictionary, boolean craftingTools) {
        ItemStack[] removed = new ItemStack[set.length];
        ItemStack[] stock = InventoryUtil.getStacks(inventory);
        if (ItemStackUtil.containsSets(set, stock, oreDictionary, craftingTools) < count) {
            return null;
        }
        for (int i = 0; i < set.length; ++i) {
            if (set[i] == null) continue;
            ItemStack stackToRemove = set[i].copy();
            stackToRemove.stackSize *= count;
            ItemStack removedStack = InventoryUtil.removeStack(inventory, stackToRemove, player, stowContainer, false, false);
            if (removedStack == null) {
                removedStack = InventoryUtil.removeStack(inventory, stackToRemove, player, stowContainer, oreDictionary, craftingTools);
            }
            removed[i] = removedStack;
        }
        return removed;
    }

    private static ItemStack removeStack(IInventory inventory, ItemStack stackToRemove, EntityPlayer player, boolean stowContainer, boolean oreDictionary, boolean craftingTools) {
        for (int j = 0; j < inventory.getSizeInventory(); ++j) {
            ItemStack stackInSlot = inventory.getStackInSlot(j);
            if (stackInSlot == null || !ItemStackUtil.isCraftingEquivalent(stackToRemove, stackInSlot, oreDictionary, craftingTools)) continue;
            ItemStack removed = inventory.decrStackSize(j, stackToRemove.stackSize);
            stackToRemove.stackSize -= removed.stackSize;
            if (stowContainer && stackToRemove.getItem().hasContainerItem(stackToRemove)) {
                InventoryUtil.stowContainerItem(removed, inventory, j, player);
            }
            if (stackToRemove.stackSize != 0) continue;
            return removed;
        }
        return null;
    }

    public static boolean contains(IInventory inventory, ItemStack[] query) {
        return InventoryUtil.contains(inventory, query, 0, inventory.getSizeInventory());
    }

    public static boolean contains(IInventory inventory, ItemStack[] query, int startSlot, int slots) {
        ItemStack[] stock = InventoryUtil.getStacks(inventory, startSlot, slots);
        return ItemStackUtil.containsSets(query, stock) > 0;
    }

    public static boolean containsPercent(IInventory inventory, float percent) {
        return InventoryUtil.containsPercent(inventory, percent, 0, inventory.getSizeInventory());
    }

    public static boolean containsPercent(IInventory inventory, float percent, int slot1, int length) {
        int amount = 0;
        int stackMax = 0;
        for (ItemStack itemStack : InventoryUtil.getStacks(inventory, slot1, length)) {
            if (itemStack == null) {
                stackMax += 64;
                continue;
            }
            amount += itemStack.stackSize;
            stackMax += itemStack.getMaxStackSize();
        }
        if (stackMax == 0) {
            return false;
        }
        return (float)amount / (float)stackMax >= percent;
    }

    public static boolean isEmpty(IInventory inventory, int slotStart, int slotCount) {
        for (int i = slotStart; i < slotStart + slotCount; ++i) {
            if (inventory.getStackInSlot(i) == null) continue;
            return false;
        }
        return true;
    }

    public static ItemStack[] getStacks(IInventory inventory) {
        ItemStack[] stacks = new ItemStack[inventory.getSizeInventory()];
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            stacks[i] = inventory.getStackInSlot(i);
        }
        return stacks;
    }

    public static ItemStack[] getStacks(IInventory inventory, int slot1, int length) {
        ItemStack[] result = new ItemStack[length];
        for (int i = slot1; i < slot1 + length; ++i) {
            result[i - slot1] = inventory.getStackInSlot(i);
        }
        return result;
    }

    public static boolean tryAddStacksCopy(IInventory inventory, ItemStack[] stacks, int startSlot, int slots, boolean all) {
        for (ItemStack stack : stacks) {
            if (stack == null || InventoryUtil.tryAddStack(inventory, stack.copy(), startSlot, slots, all)) continue;
            return false;
        }
        return true;
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, boolean all) {
        return InventoryUtil.tryAddStack(inventory, stack, 0, inventory.getSizeInventory(), all, true);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, boolean all, boolean doAdd) {
        return InventoryUtil.tryAddStack(inventory, stack, 0, inventory.getSizeInventory(), all, doAdd);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean all) {
        return InventoryUtil.tryAddStack(inventory, stack, startSlot, slots, all, true);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean all, boolean doAdd) {
        boolean success;
        int added = InventoryUtil.addStack(inventory, stack, startSlot, slots, false);
        boolean bl = all ? added == stack.stackSize : (success = added > 0);
        if (success && doAdd) {
            InventoryUtil.addStack(inventory, stack, startSlot, slots, true);
        }
        return success;
    }

    public static int addStack(IInventory inventory, ItemStack stack, boolean doAdd) {
        return InventoryUtil.addStack(inventory, stack, 0, inventory.getSizeInventory(), doAdd);
    }

    public static int addStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean doAdd) {
        int i;
        int added = 0;
        for (i = startSlot; i < startSlot + slots; ++i) {
            ItemStack inventoryStack = inventory.getStackInSlot(i);
            if (inventoryStack == null || inventoryStack.getItem() == null || !inventoryStack.isStackable() || !inventoryStack.isItemEqual(stack) || !ItemStack.areItemStackTagsEqual((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.stackSize - added;
            int space = inventoryStack.getMaxStackSize() - inventoryStack.stackSize;
            if (space <= 0) continue;
            if (space >= remain) {
                if (doAdd) {
                    inventoryStack.stackSize += remain;
                }
                return stack.stackSize;
            }
            if (doAdd) {
                inventoryStack.stackSize = inventoryStack.getMaxStackSize();
            }
            added += space;
        }
        if (added >= stack.stackSize) {
            return added;
        }
        for (i = startSlot; i < startSlot + slots; ++i) {
            if (inventory.getStackInSlot(i) != null) continue;
            if (doAdd) {
                inventory.setInventorySlotContents(i, stack.copy());
                inventory.getStackInSlot((int)i).stackSize = stack.stackSize - added;
            }
            return stack.stackSize;
        }
        return added;
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd) {
        return InventoryUtil.stowInInventory(itemstack, inventory, doAdd, 0, inventory.getSizeInventory());
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd, int slot1, int count) {
        boolean added = false;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.getStackInSlot(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.setInventorySlotContents(i, itemstack.copy());
                    itemstack.stackSize = 0;
                }
                return true;
            }
            if (inventoryStack.stackSize >= inventoryStack.getMaxStackSize() || !inventoryStack.isItemEqual(itemstack) || !ItemStack.areItemStackTagsEqual((ItemStack)inventoryStack, (ItemStack)itemstack)) continue;
            int space = inventoryStack.getMaxStackSize() - inventoryStack.stackSize;
            if (space > itemstack.stackSize) {
                if (doAdd) {
                    inventoryStack.stackSize += itemstack.stackSize;
                    itemstack.stackSize = 0;
                }
                return true;
            }
            if (doAdd) {
                inventoryStack.stackSize = inventoryStack.getMaxStackSize();
                itemstack.stackSize -= space;
            }
            added = true;
        }
        return added;
    }

    public static void stowContainerItem(ItemStack itemstack, IInventory stowing, int slotIndex, EntityPlayer player) {
        if (!itemstack.getItem().hasContainerItem(itemstack)) {
            return;
        }
        ItemStack container = itemstack.getItem().getContainerItem(itemstack);
        if (container.isItemStackDamageable() && container.getItemDamage() > container.getMaxDamage()) {
            if (player != null) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, container));
            }
            container = null;
        }
        if (container != null) {
            if (itemstack.getItem().doesContainerItemLeaveCraftingGrid(itemstack)) {
                if (!InventoryUtil.tryAddStack(stowing, container, true) && player != null && !player.inventory.addItemStackToInventory(container)) {
                    player.dropPlayerItemWithRandomChoice(container, true);
                }
            } else if (!InventoryUtil.tryAddStack(stowing, container, slotIndex, 1, true) && !InventoryUtil.tryAddStack(stowing, container, true) && player != null) {
                player.dropPlayerItemWithRandomChoice(container, true);
            }
        }
    }

    public static void dropInventory(IInventory inventory, World world, double x, double y, double z) {
        if (inventory == null) {
            return;
        }
        for (int slot = 0; slot < inventory.getSizeInventory(); ++slot) {
            ItemStack itemstack = inventory.getStackInSlot(slot);
            InventoryUtil.dropItemStackFromInventory(itemstack, world, x, y, z);
            inventory.setInventorySlotContents(slot, null);
        }
    }

    public static void dropSockets(ISocketable socketable, World world, double x, double y, double z) {
        for (int slot = 0; slot < socketable.getSocketCount(); ++slot) {
            ItemStack itemstack = socketable.getSocket(slot);
            InventoryUtil.dropItemStackFromInventory(itemstack, world, x, y, z);
            socketable.setSocket(slot, null);
        }
    }

    public static void dropItemStackFromInventory(ItemStack itemStack, World world, double x, double y, double z) {
        if (itemStack == null) {
            return;
        }
        float f = world.rand.nextFloat() * 0.8f + 0.1f;
        float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
        float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
        while (itemStack.stackSize > 0) {
            int stackPartial = world.rand.nextInt(21) + 10;
            if (stackPartial > itemStack.stackSize) {
                stackPartial = itemStack.stackSize;
            }
            ItemStack drop = itemStack.splitStack(stackPartial);
            EntityItem entityitem = new EntityItem(world, x + (double)f, y + (double)f1, z + (double)f2, drop);
            float accel = 0.05f;
            entityitem.motionX = (float)world.rand.nextGaussian() * accel;
            entityitem.motionY = (float)world.rand.nextGaussian() * accel + 0.2f;
            entityitem.motionZ = (float)world.rand.nextGaussian() * accel;
            world.spawnEntityInWorld((Entity)entityitem);
        }
    }

    public static void readFromNBT(IInventory inventory, NBTTagCompound nbttagcompound) {
        if (!nbttagcompound.hasKey(inventory.getInventoryName())) {
            return;
        }
        NBTTagList nbttaglist = nbttagcompound.getTagList(inventory.getInventoryName(), 10);
        for (int j = 0; j < nbttaglist.tagCount(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist.getCompoundTagAt(j);
            byte index = nbttagcompound2.getByte("Slot");
            inventory.setInventorySlotContents((int)index, ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound2));
        }
    }

    public static void writeToNBT(IInventory inventory, NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            if (inventory.getStackInSlot(i) == null) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.setByte("Slot", (byte)i);
            inventory.getStackInSlot(i).writeToNBT(nbttagcompound2);
            nbttaglist.appendTag((NBTBase)nbttagcompound2);
        }
        nbttagcompound.setTag(inventory.getInventoryName(), (NBTBase)nbttaglist);
    }
}

