/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.network.IStreamableGui;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.ICrafter;
import forestry.core.tiles.IRenderableTile;
import forestry.core.tiles.TileBase;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.SlotUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEscritoire
extends TileBase
implements ISidedInventory,
IRenderableTile,
ICrafter,
IStreamableGui {
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_RESULTS_1 = 1;
    public static final short SLOTS_RESULTS_COUNT = 6;
    public static final short SLOT_INPUT_1 = 7;
    public static final short SLOTS_INPUT_COUNT = 5;
    private final EscritoireGame game = new EscritoireGame();

    public TileEscritoire() {
        this.setInternalInventory(new EscritoireInventoryAdapter(this));
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.NaturalistBenchGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.game.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.game.writeToNBT(nbttagcompound);
    }

    public EscritoireGame getGame() {
        return this.game;
    }

    public void choose(GameProfile gameProfile, int index) {
        this.game.choose(index);
        this.processTurnResult(gameProfile);
    }

    private void processTurnResult(GameProfile gameProfile) {
        if (this.getGame().getStatus() != EscritoireGame.Status.SUCCESS) {
            return;
        }
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(this.getStackInSlot(0));
        if (individual == null) {
            return;
        }
        IAlleleSpecies species = individual.getGenome().getPrimary();
        for (ItemStack itemstack : species.getResearchBounty(this.worldObj, gameProfile, individual, this.game.getBountyLevel())) {
            InventoryUtil.addStack((IInventory)this.getInternalInventory(), itemstack, 1, 6, true);
        }
    }

    private boolean areProbeSlotsFilled() {
        int filledSlots = 0;
        int required = this.game.getSampleSize(5);
        for (int i = 7; i < 7 + required; ++i) {
            if (this.getStackInSlot(i) == null) continue;
            ++filledSlots;
        }
        return filledSlots >= required;
    }

    public void probe() {
        if (this.worldObj.isRemote) {
            return;
        }
        ItemStack analyze = this.getStackInSlot(0);
        if (analyze != null && this.areProbeSlotsFilled()) {
            this.game.probe(analyze, (IInventory)this, 7, 5);
        }
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.game.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.game.readData(data);
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    @Override
    public ItemStack takenFromSlot(int slotIndex, EntityPlayer player) {
        if (slotIndex == 0) {
            this.game.reset();
        }
        return null;
    }

    @Override
    public ItemStack getResult() {
        return null;
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        return true;
    }

    private static class EscritoireInventoryAdapter
    extends TileInventoryAdapter<TileEscritoire> {
        public EscritoireInventoryAdapter(TileEscritoire escritoire) {
            super(escritoire, 12, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex >= 7 && slotIndex < 7 + ((TileEscritoire)this.tile).game.getSampleSize(5)) {
                ItemStack specimen = this.getStackInSlot(0);
                if (specimen == null) {
                    return false;
                }
                IIndividual individual = AlleleManager.alleleRegistry.getIndividual(specimen);
                return individual != null && individual.getGenome().getPrimary().getResearchSuitability(itemStack) > 0.0f;
            }
            if (slotIndex == 0) {
                return AlleleManager.alleleRegistry.isIndividual(itemStack);
            }
            return false;
        }

        @Override
        public boolean isLocked(int slotIndex) {
            if (slotIndex == 0) {
                return false;
            }
            if (this.getStackInSlot(0) == null) {
                return true;
            }
            return SlotUtil.isSlotInRange(slotIndex, 7, 5) && slotIndex >= 7 + ((TileEscritoire)this.tile).game.getSampleSize(5);
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return SlotUtil.isSlotInRange(slotIndex, 1, 6);
        }

        @Override
        public void setInventorySlotContents(int slotIndex, ItemStack itemstack) {
            super.setInventorySlotContents(slotIndex, itemstack);
            if (((TileEscritoire)this.tile).worldObj == null) {
                return;
            }
            if (slotIndex == 0 && !((TileEscritoire)((TileEscritoire)this.tile)).worldObj.isRemote) {
                ItemStack ersatz;
                if (!AlleleManager.alleleRegistry.isIndividual(this.getStackInSlot(0)) && this.getStackInSlot(0) != null && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(this.getStackInSlot(0))) != null) {
                    this.setInventorySlotContents(0, ersatz);
                }
                ((TileEscritoire)this.tile).game.initialize(this.getStackInSlot(0));
            }
        }
    }
}

