/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.INBTTagable;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.tiles.EscritoireGameBoard;
import forestry.core.tiles.EscritoireGameToken;
import java.io.IOException;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class EscritoireGame
implements INBTTagable,
IStreamable {
    private static final Random rand = new Random();
    public static final int BOUNTY_MAX = 16;
    private final EscritoireGameBoard gameBoard = new EscritoireGameBoard();
    private long lastUpdate;
    private int bountyLevel;
    private Status status = Status.EMPTY;

    public EscritoireGameToken getToken(int index) {
        return this.gameBoard.getToken(index);
    }

    public Status getStatus() {
        return this.status;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setInteger("bountyLevel", this.bountyLevel);
        nbttagcompound.setLong("lastUpdate", this.lastUpdate);
        this.gameBoard.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("Status", this.status.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.bountyLevel = nbttagcompound.getInteger("bountyLevel");
        this.lastUpdate = nbttagcompound.getLong("lastUpdate");
        this.gameBoard.readFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("Status")) {
            int statusOrdinal = nbttagcompound.getInteger("Status");
            this.status = Status.values()[statusOrdinal];
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeInt(this.bountyLevel);
        this.gameBoard.writeData(data);
        data.writeEnum(this.status);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.bountyLevel = data.readInt();
        this.gameBoard.readData(data);
        this.status = data.readEnum(Status.class);
    }

    public void initialize(ItemStack specimen) {
        if (this.gameBoard.initialize(specimen)) {
            this.status = Status.PLAYING;
            this.bountyLevel = 16;
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    public void probe(ItemStack specimen, IInventory inventory, int startSlot, int slotCount) {
        if (this.status != Status.PLAYING) {
            return;
        }
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(specimen);
        if (individual == null) {
            return;
        }
        if (this.bountyLevel > 1) {
            --this.bountyLevel;
        }
        IAlleleSpecies species = individual.getGenome().getPrimary();
        this.gameBoard.hideProbedTokens();
        int revealCount = this.getSampleSize(slotCount);
        for (int i = 0; i < revealCount; ++i) {
            ItemStack sample = inventory.decrStackSize(startSlot + i, 1);
            if (sample == null || sample.stackSize <= 0 || !(rand.nextFloat() < species.getResearchSuitability(sample))) continue;
            this.gameBoard.probe();
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void reset() {
        this.bountyLevel = 16;
        this.gameBoard.reset();
        this.status = Status.EMPTY;
        this.lastUpdate = System.currentTimeMillis();
    }

    public void choose(int tokenIndex) {
        if (this.getStatus() != Status.PLAYING) {
            return;
        }
        EscritoireGameToken token = this.gameBoard.getToken(tokenIndex);
        if (token != null) {
            this.status = this.gameBoard.choose(token);
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    public int getBountyLevel() {
        return this.bountyLevel;
    }

    public int getSampleSize(int slotCount) {
        if (this.status == Status.EMPTY) {
            return 0;
        }
        int samples = this.gameBoard.getTokenCount() / 4;
        samples = Math.max(samples, 2);
        return Math.min(samples, slotCount);
    }

    public static enum Status {
        EMPTY,
        PLAYING,
        FAILURE,
        SUCCESS;

    }
}

