/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import cpw.mods.fml.common.registry.GameData;
import forestry.core.network.IStreamable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class DataOutputStreamForestry
extends DataOutputStream {
    public DataOutputStreamForestry(OutputStream out) {
        super(out);
    }

    public void writeItemStack(ItemStack itemstack) throws IOException {
        if (itemstack == null) {
            this.writeUTF("");
        } else {
            this.writeUTF(GameData.getItemRegistry().getNameForObject((Object)itemstack.getItem()));
            this.writeByte(itemstack.stackSize);
            this.writeVarInt(itemstack.getItemDamage());
            if (itemstack.getItem().isDamageable() || itemstack.getItem().getShareTag()) {
                this.writeNBTTagCompound(itemstack.stackTagCompound);
            }
        }
    }

    public void writeItemStacks(ItemStack[] itemStacks) throws IOException {
        this.writeVarInt(itemStacks.length);
        for (ItemStack itemstack : itemStacks) {
            this.writeItemStack(itemstack);
        }
    }

    public void writeInventory(IInventory inventory) throws IOException {
        int size = inventory.getSizeInventory();
        this.writeVarInt(size);
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            this.writeItemStack(stack);
        }
    }

    public void writeStreamable(IStreamable streamable) throws IOException {
        if (streamable != null) {
            this.writeBoolean(true);
            streamable.writeData(this);
        } else {
            this.writeBoolean(false);
        }
    }

    public <T extends IStreamable> void writeStreamables(List<T> streamables) throws IOException {
        if (streamables == null) {
            this.writeVarInt(0);
        } else {
            this.writeVarInt(streamables.size());
            for (IStreamable streamable : streamables) {
                this.writeStreamable(streamable);
            }
        }
    }

    public void writeVarInt(int varInt) throws IOException {
        while ((varInt & 0xFFFFFF80) != 0) {
            this.writeByte(varInt & 0x7F | 0x80);
            varInt >>>= 7;
        }
        this.writeByte(varInt);
    }

    public void writeEnum(Enum enumValue) throws IOException {
        this.writeVarInt(enumValue.ordinal());
    }

    public void writeNBTTagCompound(NBTTagCompound nbttagcompound) throws IOException {
        if (nbttagcompound == null) {
            this.writeVarInt(-1);
        } else {
            byte[] compressed = CompressedStreamTools.compress((NBTTagCompound)nbttagcompound);
            this.writeVarInt((short)compressed.length);
            this.write(compressed);
        }
    }

    public void writeFluidStack(FluidStack fluidStack) throws IOException {
        if (fluidStack == null) {
            this.writeVarInt(-1);
        } else {
            this.writeVarInt(fluidStack.getFluidID());
            this.writeVarInt(fluidStack.amount);
        }
    }
}

