/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IPacketId;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketIdClient;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.TileForestry;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketItemStackDisplay
extends PacketCoordinates
implements IForestryPacketClient {
    private ItemStack itemStack;

    public PacketItemStackDisplay() {
    }

    public <T extends TileForestry> PacketItemStackDisplay(T tile, ItemStack itemStack) {
        super((IPacketId)PacketIdClient.ITEMSTACK_DISPLAY, tile);
        this.itemStack = itemStack;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeItemStack(this.itemStack);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.itemStack = data.readItemStack();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof IItemStackDisplay) {
            ((IItemStackDisplay)tile).handleItemStackForDisplay(this.itemStack);
        }
    }
}

