/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.items;

import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.items.ItemAlyzer;
import forestry.core.network.GuiId;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemFlutterlyzer
extends ItemAlyzer {
    public ItemFlutterlyzer() {
        this.setMaxStackSize(1);
        this.setCreativeTab(Tabs.tabLepidopterology);
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.isRemote) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.FlutterlyzerGUI.ordinal(), world, (int)entityplayer.posX, (int)entityplayer.posY, (int)entityplayer.posZ);
        }
        return itemstack;
    }

    public static class FlutterlyzerInventory
    extends ItemAlyzer.AlyzerInventory
    implements IHintSource {
        public FlutterlyzerInventory(EntityPlayer player, ItemStack itemStack) {
            super(player, 7, itemStack);
        }

        @Override
        protected ISpeciesRoot getSpeciesRoot() {
            return ButterflyManager.butterflyRoot;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("flutterlyzer");
        }
    }
}

