/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import forestry.core.commands.IForestryCommand;
import forestry.core.commands.SubCommand;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandHelpers {
    public static World getWorld(ICommandSender sender, IForestryCommand command, String[] args, int worldArgIndex) {
        if (worldArgIndex < args.length) {
            try {
                int dim = Integer.parseInt(args[worldArgIndex]);
                WorldServer world = MinecraftServer.getServer().worldServerForDimension(dim);
                if (world != null) {
                    return world;
                }
            }
            catch (Exception ex) {
                CommandHelpers.throwWrongUsage(sender, command);
            }
        }
        return CommandHelpers.getWorld(sender, command);
    }

    public static World getWorld(ICommandSender sender, IForestryCommand command) {
        return sender.getEntityWorld();
    }

    public static EntityPlayerMP getPlayer(ICommandSender sender, String playerName) {
        return CommandBase.getPlayer((ICommandSender)sender, (String)playerName);
    }

    public static String[] getPlayers() {
        return MinecraftServer.getServer().getAllUsernames();
    }

    public static void sendLocalizedChatMessage(ICommandSender sender, String locTag, Object ... args) {
        sender.addChatMessage((IChatComponent)new ChatComponentTranslation(locTag, args));
    }

    public static void sendLocalizedChatMessage(ICommandSender sender, ChatStyle chatStyle, String locTag, Object ... args) {
        ChatComponentTranslation chat = new ChatComponentTranslation(locTag, args);
        chat.setChatStyle(chatStyle);
        sender.addChatMessage((IChatComponent)chat);
    }

    public static void sendChatMessage(ICommandSender sender, String message) {
        sender.addChatMessage((IChatComponent)new ChatComponentText(message));
    }

    public static void throwWrongUsage(ICommandSender sender, IForestryCommand command) throws WrongUsageException {
        throw new WrongUsageException(StringUtil.localizeAndFormat("chat.help", command.getCommandUsage(sender)), new Object[0]);
    }

    public static void processChildCommand(ICommandSender sender, SubCommand child, String[] args) {
        if (!sender.canCommandSenderUseCommand(child.getPermissionLevel(), child.getFullCommandString())) {
            throw new WrongUsageException(StringUtil.localize("chat.command.noperms"), new Object[0]);
        }
        String[] newargs = new String[args.length - 1];
        System.arraycopy(args, 1, newargs, 0, newargs.length);
        child.processCommand(sender, newargs);
    }

    public static void printHelp(ICommandSender sender, IForestryCommand command) {
        int permLevel;
        String commandString = command.getFullCommandString().replace(" ", ".");
        ChatStyle header = new ChatStyle();
        header.setColor(EnumChatFormatting.BLUE);
        CommandHelpers.sendLocalizedChatMessage(sender, header, "for.chat.command." + commandString + ".format", command.getFullCommandString());
        ChatStyle body = new ChatStyle();
        body.setColor(EnumChatFormatting.GRAY);
        List<String> commandAliases = command.getCommandAliases();
        if (commandAliases.size() > 0) {
            CommandHelpers.sendLocalizedChatMessage(sender, body, "for.chat.command.aliases", commandAliases.toString().replace("[", "").replace("]", ""));
        }
        if ((permLevel = command.getPermissionLevel()) > 0) {
            CommandHelpers.sendLocalizedChatMessage(sender, body, "for.chat.command.permlevel", permLevel);
        }
        CommandHelpers.sendLocalizedChatMessage(sender, body, "for.chat.command." + commandString + ".help", new Object[0]);
        if (!command.getChildren().isEmpty()) {
            CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.list", new Object[0]);
            for (SubCommand child : command.getChildren()) {
                CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command." + child.getFullCommandString().replace(" ", ".") + ".desc", child.getCommandName());
            }
        }
    }

    public static boolean processStandardCommands(ICommandSender sender, IForestryCommand command, String[] args) {
        if (args.length >= 1) {
            if (args[0].equals("help")) {
                command.printHelp(sender);
                return true;
            }
            for (SubCommand child : command.getChildren()) {
                if (!CommandHelpers.matches(args[0], child)) continue;
                CommandHelpers.processChildCommand(sender, child, args);
                return true;
            }
        }
        return false;
    }

    public static boolean matches(String commandName, IForestryCommand command) {
        if (commandName.equals(command.getCommandName())) {
            return true;
        }
        if (command.getCommandAliases() != null) {
            for (String alias : command.getCommandAliases()) {
                if (!commandName.equals(alias)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> getListOfStringsMatchingLastWord(String[] strings, String ... lastWords) {
        return CommandBase.getListOfStringsMatchingLastWord((String[])strings, (String[])lastWords);
    }

    public static List<String> addStandardTabCompletionOptions(IForestryCommand command, ICommandSender sender, String[] incomplete) {
        if (incomplete.length > 1) {
            String commandName = incomplete[0];
            for (SubCommand child : command.getChildren()) {
                if (!CommandHelpers.matches(commandName, child)) continue;
                String[] incompleteRemaining = Arrays.copyOfRange(incomplete, 1, incomplete.length);
                return child.addTabCompletionOptions(sender, incompleteRemaining);
            }
        }
        ArrayList<String> commandNames = new ArrayList<String>();
        for (SubCommand child : command.getChildren()) {
            commandNames.add(child.getCommandName());
        }
        commandNames.add("help");
        String[] commandNamesArr = commandNames.toArray(new String[commandNames.size()]);
        return CommandHelpers.getListOfStringsMatchingLastWord(incomplete, commandNamesArr);
    }
}

