/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.api.genetics.IPollinatable;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.core.utils.GeneticsUtil;
import forestry.lepidopterology.entities.AIButterflyInteract;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.plugins.PluginLepidopterology;

public class AIButterflyMate
extends AIButterflyInteract {
    public AIButterflyMate(EntityButterfly entity) {
        super(entity);
    }

    @Override
    protected boolean canInteract() {
        if (this.entity.cooldownEgg > 0) {
            return false;
        }
        if (this.entity.getButterfly().getMate() == null) {
            return false;
        }
        if (this.entity.worldObj.countEntities(EntityButterfly.class) > PluginLepidopterology.spawnConstraint) {
            return false;
        }
        return GeneticsUtil.canNurse(this.entity.getButterfly(), this.entity.worldObj, this.rest.posX, this.rest.posY, this.rest.posZ);
    }

    public void updateTask() {
        if (this.continueExecuting()) {
            IButterflyNursery nursery;
            IPollinatable tile = GeneticsUtil.getOrCreatePollinatable(null, this.entity.worldObj, this.rest.posX, this.rest.posY, this.rest.posZ);
            if (tile instanceof IButterflyNursery && (nursery = (IButterflyNursery)((Object)tile)).canNurse(this.entity.getButterfly())) {
                nursery.setCaterpillar(this.entity.getButterfly().spawnCaterpillar(nursery));
                if (this.entity.getRNG().nextFloat() < 1.0f / (float)this.entity.getButterfly().getGenome().getFertility()) {
                    this.entity.setHealth(0.0f);
                }
            }
            this.setHasInteracted();
            this.entity.cooldownEgg = 1500;
        }
    }
}

