/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.genetics.EffectData;
import forestry.core.utils.vect.Vect;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;

public class AlleleEffectFungification
extends AlleleEffectThrottled {
    private static final int MAX_BLOCK_FIND_TRIES = 10;
    private static final int ENTITY_THROTTLE = 6;

    public AlleleEffectFungification() {
        super("mycophilic", true, 10, false, false);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData instanceof EffectData && ((EffectData)storedData).getIntSize() == 2) {
            return storedData;
        }
        return new EffectData(2, 0);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        this.doBlockEffect(genome, housing);
        int entityThrottle = storedData.getInteger(1);
        if (entityThrottle >= 6) {
            this.doEntityEffect(genome, housing);
            entityThrottle = 0;
        } else {
            ++entityThrottle;
        }
        storedData.setInteger(1, entityThrottle);
        return storedData;
    }

    private void doBlockEffect(IBeeGenome genome, IBeeHousing housing) {
        World world = housing.getWorld();
        ChunkCoordinates housingCoordinates = housing.getCoordinates();
        Vect area = this.getModifiedArea(genome, housing);
        int blockX = AlleleEffectFungification.getRandomOffset(world.rand, housingCoordinates.posX, area.getX());
        int blockY = AlleleEffectFungification.getRandomOffset(world.rand, housingCoordinates.posY, area.getY());
        int blockZ = AlleleEffectFungification.getRandomOffset(world.rand, housingCoordinates.posZ, area.getZ());
        for (int attempt = 0; attempt < 10; ++attempt) {
            Block block = world.getBlock(blockX, blockY, blockZ);
            if (AlleleEffectFungification.isSuitableForMycelium(world, block, blockX, blockY, blockZ)) {
                world.setBlock(blockX, blockY, blockZ, (Block)Blocks.mycelium);
                break;
            }
            if (AlleleEffectFungification.isSuitableForGrowth(block)) {
                AlleleEffectFungification.doMushroomGrowth(block, world, blockX, blockY, blockZ);
                break;
            }
            blockX = AlleleEffectFungification.getRandomOffset(world.rand, housingCoordinates.posX, area.getX());
            blockY = AlleleEffectFungification.getRandomOffset(world.rand, housingCoordinates.posY, area.getY());
            blockZ = AlleleEffectFungification.getRandomOffset(world.rand, housingCoordinates.posZ, area.getZ());
        }
    }

    private void doEntityEffect(IBeeGenome genome, IBeeHousing housing) {
        AxisAlignedBB aabb = this.getBounding(genome, housing);
        World world = housing.getWorld();
        List entities = world.getEntitiesWithinAABB(EntityCow.class, aabb);
        for (Object entity : entities) {
            if (!(entity instanceof EntityCow) || entity instanceof EntityMooshroom) continue;
            AlleleEffectFungification.convertCowToMooshroom((EntityCow)entity);
            break;
        }
    }

    private static int getRandomOffset(Random random, int centrePos, int offset) {
        return centrePos + random.nextInt(offset) - offset / 2;
    }

    private static boolean isSuitableForMycelium(World world, Block block, int blockX, int blockY, int blockZ) {
        return block == Blocks.grass || block == Blocks.dirt && world.canBlockSeeTheSky(blockX, blockY, blockZ);
    }

    private static boolean isSuitableForGrowth(Block block) {
        return block == Blocks.red_mushroom || block == Blocks.brown_mushroom;
    }

    private static void convertCowToMooshroom(EntityCow cow) {
        World worldObj = cow.worldObj;
        cow.setDead();
        EntityMooshroom mooshroom = new EntityMooshroom(worldObj);
        mooshroom.setLocationAndAngles(cow.posX, cow.posY, cow.posZ, cow.rotationYaw, cow.rotationPitch);
        mooshroom.setHealth(cow.getHealth());
        mooshroom.renderYawOffset = cow.renderYawOffset;
        worldObj.spawnEntityInWorld((Entity)mooshroom);
        worldObj.spawnParticle("largeexplode", cow.posX, cow.posY + (double)(cow.height / 2.0f), cow.posZ, 0.0, 0.0, 0.0);
    }

    private static void doMushroomGrowth(Block block, World world, int blockX, int blockY, int blockZ) {
        WorldGenBigMushroom giantMushroomGenerator = block == Blocks.brown_mushroom ? new WorldGenBigMushroom(0) : new WorldGenBigMushroom(1);
        world.setBlockToAir(blockX, blockY, blockZ);
        giantMushroomGenerator.generate(world, world.rand, blockX, blockY, blockZ);
    }
}

