/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.vect.IVect;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.logic.FarmLogicWatered;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class FarmLogicCrops
extends FarmLogicWatered {
    private final Iterable<IFarmable> seeds;
    private static final ItemStack farmland = new ItemStack(Blocks.farmland, 1, Short.MAX_VALUE);

    protected FarmLogicCrops(IFarmHousing housing, Iterable<IFarmable> seeds) {
        super(housing, new ItemStack(Blocks.dirt), new ItemStack(Blocks.farmland));
        this.seeds = seeds;
    }

    @Override
    public boolean isAcceptedGround(ItemStack itemStack) {
        return super.isAcceptedGround(itemStack) || ItemStackUtil.isIdenticalItem(farmland, itemStack);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    private boolean isWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        ArrayList products = this.produce;
        this.produce = new ArrayList();
        Vect coords = new Vect(this.housing.getCoords());
        Vect area = new Vect(this.housing.getArea());
        Vect offset = new Vect(this.housing.getOffset());
        Vect min = coords.add(offset);
        Vect max = min.add(area);
        AxisAlignedBB harvestBox = AxisAlignedBB.getBoundingBox((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = this.housing.getWorld().getEntitiesWithinAABB(Entity.class, harvestBox);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack contained;
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityItem)) continue;
            EntityItem item = (EntityItem)entity;
            if (item.isDead || !this.isAcceptedGermling(contained = item.getEntityItem()) && !this.isWindfall(contained)) continue;
            this.produce.add(contained.copy());
            item.setDead();
        }
        return products;
    }

    @Override
    protected boolean maintainCrops(int x, int y, int z, FarmDirection direction, int extent) {
        World world = this.getWorld();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!VectUtil.isAirBlock(world, position) && !BlockUtil.isReplaceableBlock(this.getWorld(), position.x, position.y, position.z)) continue;
            ItemStack below = VectUtil.getAsItemStack(world, position.add(0, -1, 0));
            if (this.ground.getItem() != below.getItem() || below.getItemDamage() <= 0) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(IVect position) {
        World world = this.getWorld();
        for (IFarmable candidate : this.seeds) {
            if (!this.housing.plantGermling(candidate, world, position.getX(), position.getY(), position.getZ())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, FarmDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y + 1, z, direction, i);
            for (IFarmable seed : this.seeds) {
                ICrop crop = seed.getCropAt(world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

