/*
 * Decompiled with CFR 0.152.
 */
package forestry.food;

import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.core.utils.StringUtil;
import forestry.food.BeverageEffectAntidote;
import forestry.food.BeverageEffectDrunk;

public abstract class BeverageEffect
implements IBeverageEffect {
    public static final IBeverageEffect weakAlcoholic = new BeverageEffectDrunk(10, 0.2f);
    public static final IBeverageEffect weakAntidote = new BeverageEffectAntidote(20, 0.5f);
    public static final IBeverageEffect strongAntidote = new BeverageEffectAntidote(21, 1.0f);
    private final int id;
    protected String description;

    protected BeverageEffect(int id) {
        this.id = id;
        if (BeverageManager.effectList[id] != null) {
            throw new RuntimeException("Beverage effect slot " + id + " was already occupied by " + BeverageManager.effectList[id].toString() + " when trying to add " + this.toString());
        }
        BeverageManager.effectList[id] = this;
    }

    @Override
    public int getId() {
        return this.id;
    }

    protected String getLevel() {
        return null;
    }

    @Override
    public String getDescription() {
        if (this.getLevel() != null) {
            return StringUtil.localize(this.description) + " " + this.getLevel();
        }
        return StringUtil.localize(this.description);
    }
}

