/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.tiles;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TileEngine;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEngineBiogas
extends TileEngine
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler {
    public static final short SLOT_CAN = 0;
    private final FilteredTank fuelTank;
    private final FilteredTank heatingTank;
    private final TankManager tankManager;
    public int burnTime;
    public int totalTime;
    public int currentFluidId = -1;
    private boolean shutdown;

    public TileEngineBiogas() {
        super(10000, 300000);
        this.setHints(Config.hints.get("engine.bronze"));
        this.setInternalInventory(new EngineBronzeInventoryAdapter(this));
        this.fuelTank = new FilteredTank(10000, FuelManager.bronzeEngineFuel.keySet());
        this.fuelTank.tankMode = StandardTank.TankMode.DEFAULT;
        this.heatingTank = new FilteredTank(10000, FluidRegistry.LAVA);
        this.heatingTank.tankMode = StandardTank.TankMode.INPUT;
        this.tankManager = new TankManager(this, this.fuelTank, this.heatingTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.EngineBiogasGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (!this.updateOnInterval(20)) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(0) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)inventory, 0);
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        boolean hasHeat = this.getHeatLevel() > 0.2 || this.heatingTank.getFluidAmount() > 0;
        errorLogic.setCondition(!hasHeat, EnumErrorCode.NOHEAT);
        boolean hasFuel = this.burnTime > 0 || this.fuelTank.getFluidAmount() > 0;
        errorLogic.setCondition(!hasFuel, EnumErrorCode.NOFUEL);
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.isRedstoneActivated() && (this.fuelTank.getFluidAmount() >= 1000 || this.burnTime > 0)) {
            double heatStage = this.getHeatLevel();
            if (heatStage > 0.25 && this.shutdown) {
                this.shutdown(false);
            } else if (this.shutdown && this.heatingTank.getFluidAmount() > 0 && Fluids.LAVA.is(this.heatingTank.getFluid())) {
                this.addHeat(20);
                this.heatingTank.drain(1, true);
            }
            if (heatStage > 0.2) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                    this.currentOutput = TileEngineBiogas.determineFuelValue(FluidRegistry.getFluid((int)this.currentFluidId));
                    this.energyManager.generateEnergy(this.currentOutput);
                } else {
                    this.burnTime = this.totalTime = TileEngineBiogas.determineBurnTime(this.fuelTank.getFluid().getFluid());
                    this.currentFluidId = this.fuelTank.getFluid().getFluid().getID();
                    this.fuelTank.drain(1000, true);
                }
            } else {
                this.shutdown(true);
            }
        }
        if (this.burnTime <= 0) {
            this.currentFluidId = -1;
        }
    }

    private void shutdown(boolean val) {
        this.shutdown = val;
    }

    @Override
    public int dissipateHeat() {
        FluidStack fuelFluidStack;
        EngineBronzeFuel fuel;
        double heatStage;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 1;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((heatStage = this.getHeatLevel()) > 0.55) {
            ++loss;
        }
        if (this.fuelTank.getFluidAmount() > 0 && (fuel = FuelManager.bronzeEngineFuel.get((fuelFluidStack = this.fuelTank.getFluid()).getFluid())) != null) {
            loss *= fuel.dissipationMultiplier;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int generate = 0;
        if (this.isRedstoneActivated() && this.burnTime > 0) {
            double heatStage = this.getHeatLevel();
            if (heatStage >= 0.75) {
                generate += 3;
            } else if (heatStage > 0.24) {
                generate += 2;
            } else if (heatStage > 0.2) {
                ++generate;
            }
        }
        this.heat += generate;
        return generate;
    }

    private static int determineFuelValue(Fluid fluid) {
        if (FuelManager.bronzeEngineFuel.containsKey(fluid)) {
            return FuelManager.bronzeEngineFuel.get((Object)fluid).powerPerCycle;
        }
        return 0;
    }

    private static int determineBurnTime(Fluid fluid) {
        if (FuelManager.bronzeEngineFuel.containsKey(fluid)) {
            return FuelManager.bronzeEngineFuel.get((Object)fluid).burnDuration;
        }
        return 0;
    }

    @Override
    protected boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getOperatingTemperatureScaled(int i) {
        return (int)Math.round((double)(this.heat * i) / ((double)this.maxHeat * 0.2));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        Fluid fluid;
        super.readFromNBT(nbt);
        this.burnTime = nbt.getInteger("EngineBurnTime");
        this.totalTime = nbt.getInteger("EngineTotalTime");
        if (nbt.hasKey("currentFluid") && (fluid = FluidRegistry.getFluid((String)nbt.getString("currentFluid"))) != null) {
            this.currentFluidId = fluid.getID();
        }
        this.tankManager.readFromNBT(nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.setInteger("EngineBurnTime", this.burnTime);
        nbt.setInteger("EngineTotalTime", this.totalTime);
        Fluid fluid = FluidRegistry.getFluid((int)this.currentFluidId);
        if (fluid != null) {
            nbt.setString("currentFluid", fluid.getName());
        }
        this.tankManager.writeToNBT(nbt);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.shutdown);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.shutdown = data.readBoolean();
        this.tankManager.readData(data);
    }

    @Override
    public void getGUINetworkData(int id, int data) {
        switch (id -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.burnTime = data;
                break;
            }
            case 1: {
                this.totalTime = data;
                break;
            }
            case 2: {
                this.currentOutput = data;
                break;
            }
            case 3: {
                this.energyManager.fromGuiInt(data);
                break;
            }
            case 4: {
                this.heat = data;
                break;
            }
            case 5: {
                this.currentFluidId = data;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.sendProgressBarUpdate(containerEngine, i, this.burnTime);
        iCrafting.sendProgressBarUpdate(containerEngine, i + 1, this.totalTime);
        iCrafting.sendProgressBarUpdate(containerEngine, i + 2, this.currentOutput);
        iCrafting.sendProgressBarUpdate(containerEngine, i + 3, this.energyManager.toGuiInt());
        iCrafting.sendProgressBarUpdate(containerEngine, i + 4, this.heat);
        iCrafting.sendProgressBarUpdate(containerEngine, i + 5, this.currentFluidId);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class EngineBronzeInventoryAdapter
    extends TileInventoryAdapter<TileEngineBiogas> {
        public EngineBronzeInventoryAdapter(TileEngineBiogas engineBronze) {
            super(engineBronze, 1, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((TileEngineBiogas)this.tile).tankManager.accepts(fluid);
            }
            return false;
        }
    }
}

