/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import buildcraft.api.statements.ITriggerExternal;
import com.google.common.base.Objects;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.triggers.FactoryTriggers;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidTank;

public class TileBottler
extends TilePowered
implements ISidedInventory,
ILiquidTankTile {
    private static final int TICKS_PER_RECIPE_TIME = 10;
    private static final int ENERGY_PER_RECIPE_TIME = 750;
    public static final short SLOT_INPUT_EMPTY_CAN = 0;
    public static final short SLOT_OUTPUT = 1;
    public static final short SLOT_INPUT_FULL_CAN = 2;
    private final StandardTank resourceTank;
    private final TankManager tankManager;
    private BottlerRecipe currentRecipe;

    public TileBottler() {
        super(1100, 4000, 200);
        this.setInternalInventory(new BottlerInventoryAdapter(this));
        this.setHints(Config.hints.get("bottler"));
        this.resourceTank = new StandardTank(10000);
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.BottlerGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        this.checkRecipe();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (!this.updateOnInterval(20)) {
            return;
        }
        if (this.getStackInSlot(2) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 2);
        }
    }

    @Override
    public boolean workCycle() {
        FluidHelper.FillStatus status = FluidHelper.fillContainers(this.tankManager, (IInventory)this, 0, 1, this.currentRecipe.input.getFluid());
        return status == FluidHelper.FillStatus.SUCCESS;
    }

    private void checkRecipe() {
        ItemStack emptyCan = this.getStackInSlot(0);
        FluidStack resource = this.resourceTank.getFluid();
        if (this.currentRecipe == null || !this.currentRecipe.matches(emptyCan, resource)) {
            this.currentRecipe = BottlerRecipe.getRecipe(resource, emptyCan);
            if (this.currentRecipe != null) {
                float viscosityMultiplier = (float)resource.getFluid().getViscosity(resource) / 1000.0f;
                viscosityMultiplier = (viscosityMultiplier - 1.0f) / 20.0f + 1.0f;
                int fillAmount = Math.min(this.currentRecipe.input.amount, resource.amount);
                float fillTime = (float)fillAmount / 1000.0f;
                this.setTicksPerWorkCycle(Math.round((fillTime *= viscosityMultiplier) * 10.0f));
                this.setEnergyPerWorkCycle(Math.round(fillTime * 750.0f));
            }
        }
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(0) == null) {
            return false;
        }
        return (float)inventory.getStackInSlot((int)0).stackSize / (float)inventory.getStackInSlot(0).getMaxStackSize() > percentage;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        IErrorLogic errorLogic = this.getErrorLogic();
        FluidHelper.FillStatus status = errorLogic.setCondition(this.currentRecipe == null, EnumErrorCode.NORECIPE) ? FluidHelper.FillStatus.SUCCESS : FluidHelper.fillContainers(this.tankManager, (IInventory)this, 0, 1, this.currentRecipe.input.getFluid(), false);
        errorLogic.setCondition(status == FluidHelper.FillStatus.NO_FLUID, EnumErrorCode.NORESOURCE);
        errorLogic.setCondition(status == FluidHelper.FillStatus.NO_SPACE, EnumErrorCode.NOSPACE);
        return this.currentRecipe != null && status == FluidHelper.FillStatus.SUCCESS;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(FactoryTriggers.lowResource25);
        res.add(FactoryTriggers.lowResource10);
        return res;
    }

    public static class BottlerRecipe {
        public final FluidStack input;
        public final ItemStack empty;
        public final ItemStack filled;

        private BottlerRecipe(ItemStack empty, ItemStack filled) {
            this.input = FluidHelper.getFluidStackInContainer(filled);
            if (empty.getItem() instanceof IFluidContainerItem) {
                FluidStack emptyFluid = FluidHelper.getFluidStackInContainer(empty);
                if (emptyFluid != null) {
                    this.input.amount -= emptyFluid.amount;
                }
                if (this.input.amount > 1000) {
                    this.input.amount = 1000;
                }
            }
            this.empty = empty;
            this.filled = filled;
        }

        public boolean matches(ItemStack emptyCan, FluidStack resource) {
            if (emptyCan == null || resource == null || !emptyCan.isItemEqual(this.empty)) {
                return false;
            }
            if (this.empty.getItem() instanceof IFluidContainerItem) {
                return true;
            }
            return resource.containsFluid(this.input);
        }

        public static BottlerRecipe getRecipe(FluidStack res, ItemStack empty) {
            if (res == null || empty == null) {
                return null;
            }
            ItemStack filled = FluidHelper.getFilledContainer(res.getFluid(), empty);
            if (filled == null) {
                return null;
            }
            return new BottlerRecipe(empty, filled);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).addValue(this.input.amount).addValue((Object)this.input.getLocalizedName()).add("empty", (Object)this.empty).add("filled", (Object)this.filled).toString();
        }
    }

    private static class BottlerInventoryAdapter
    extends TileInventoryAdapter<TileBottler> {
        public BottlerInventoryAdapter(TileBottler tileBottler) {
            super(tileBottler, 3, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return FluidHelper.isFillableContainer(itemStack);
            }
            if (slotIndex == 2) {
                FluidStack fluidStack = FluidHelper.getFluidStackInContainer(itemStack);
                return fluidStack != null && FluidRegistry.isFluidRegistered((Fluid)fluidStack.getFluid());
            }
            return false;
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 1;
        }
    }
}

