/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.gui.slots.SlotForestry;
import forestry.core.utils.ItemStackUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class SlotUtil {
    private static final int playerInventorySize = 36;
    private static final int playerHotbarSize = 9;

    public static boolean isSlotInRange(int slotIndex, int start, int count) {
        return slotIndex >= start && slotIndex < start + count;
    }

    public static ItemStack slotClickPhantom(Slot slot, int mouseButton, int modifier, EntityPlayer player) {
        ItemStack stack = null;
        ItemStack stackSlot = slot.getStack();
        if (stackSlot != null) {
            stack = stackSlot.copy();
        }
        if (mouseButton == 2) {
            SlotUtil.fillPhantomSlot(slot, null, mouseButton);
        } else if (mouseButton == 0 || mouseButton == 1) {
            InventoryPlayer playerInv = player.inventory;
            ItemStack stackHeld = playerInv.getItemStack();
            if (stackSlot == null) {
                if (stackHeld != null && slot.isItemValid(stackHeld)) {
                    SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            } else if (stackHeld == null) {
                SlotUtil.adjustPhantomSlot(slot, mouseButton, modifier);
            } else if (slot.isItemValid(stackHeld)) {
                if (ItemStackUtil.isIdenticalItem(stackSlot, stackHeld)) {
                    SlotUtil.adjustPhantomSlot(slot, mouseButton, modifier);
                } else {
                    SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            }
        } else if (mouseButton == 5) {
            InventoryPlayer playerInv = player.inventory;
            ItemStack stackHeld = playerInv.getItemStack();
            if (!slot.getHasStack()) {
                SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
            }
        }
        return stack;
    }

    public static ItemStack transferStackInSlot(List inventorySlots, EntityPlayer player, int slotIndex) {
        Slot slot = (Slot)inventorySlots.get(slotIndex);
        if (slot == null || !slot.getHasStack()) {
            return null;
        }
        int numSlots = inventorySlots.size();
        ItemStack stackInSlot = slot.getStack();
        ItemStack originalStack = stackInSlot.copy();
        if (!SlotUtil.shiftItemStack(inventorySlots, stackInSlot, slotIndex, numSlots)) {
            return null;
        }
        slot.onSlotChange(stackInSlot, originalStack);
        if (stackInSlot.stackSize <= 0) {
            slot.putStack(null);
        } else {
            slot.onSlotChanged();
        }
        if (stackInSlot.stackSize == originalStack.stackSize) {
            return null;
        }
        slot.onPickupFromSlot(player, stackInSlot);
        return originalStack;
    }

    private static boolean shiftItemStack(List inventorySlots, ItemStack stackInSlot, int slotIndex, int numSlots) {
        if (SlotUtil.isInPlayerInventory(slotIndex)) {
            if (SlotUtil.shiftToMachineInventory(inventorySlots, stackInSlot, numSlots)) {
                return true;
            }
            if (SlotUtil.isInPlayerHotbar(slotIndex)) {
                return SlotUtil.shiftToPlayerInventoryNoHotbar(inventorySlots, stackInSlot);
            }
            return SlotUtil.shiftToHotbar(inventorySlots, stackInSlot);
        }
        return SlotUtil.shiftToPlayerInventory(inventorySlots, stackInSlot);
    }

    private static void adjustPhantomSlot(Slot slot, int mouseButton, int modifier) {
        int stackSize;
        if (!((SlotForestry)slot).canAdjustPhantom()) {
            return;
        }
        ItemStack stackSlot = slot.getStack();
        if (modifier == 1) {
            stackSize = mouseButton == 0 ? (stackSlot.stackSize + 1) / 2 : stackSlot.stackSize * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.stackSize - 1 : stackSlot.stackSize + 1;
        }
        if (stackSize > slot.getSlotStackLimit()) {
            stackSize = slot.getSlotStackLimit();
        }
        stackSlot.stackSize = stackSize;
        if (stackSlot.stackSize <= 0) {
            stackSlot = null;
        }
        slot.putStack(stackSlot);
    }

    private static void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton) {
        int stackSize;
        if (!((SlotForestry)slot).canAdjustPhantom()) {
            return;
        }
        if (stackHeld == null) {
            slot.putStack(null);
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.stackSize : 1;
        if (stackSize > slot.getSlotStackLimit()) {
            stackSize = slot.getSlotStackLimit();
        }
        ItemStack phantomStack = stackHeld.copy();
        phantomStack.stackSize = stackSize;
        slot.putStack(phantomStack);
    }

    private static boolean shiftItemStackToRange(List inventorySlots, ItemStack stackToShift, int start, int count) {
        boolean changed = SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackToShift, start, count);
        return changed |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackToShift, start, count);
    }

    private static boolean shiftItemStackToRangeMerge(List inventorySlots, ItemStack stackToShift, int start, int count) {
        if (stackToShift == null || !stackToShift.isStackable() || stackToShift.stackSize <= 0) {
            return false;
        }
        boolean changed = false;
        for (int slotIndex = start; stackToShift.stackSize > 0 && slotIndex < start + count; ++slotIndex) {
            Slot slot = (Slot)inventorySlots.get(slotIndex);
            ItemStack stackInSlot = slot.getStack();
            if (stackInSlot == null || !ItemStackUtil.isIdenticalItem(stackInSlot, stackToShift)) continue;
            int resultingStackSize = stackInSlot.stackSize + stackToShift.stackSize;
            int max = Math.min(stackToShift.getMaxStackSize(), slot.getSlotStackLimit());
            if (resultingStackSize <= max) {
                stackToShift.stackSize = 0;
                stackInSlot.stackSize = resultingStackSize;
                slot.onSlotChanged();
                changed = true;
                continue;
            }
            if (stackInSlot.stackSize >= max) continue;
            stackToShift.stackSize -= max - stackInSlot.stackSize;
            stackInSlot.stackSize = max;
            slot.onSlotChanged();
            changed = true;
        }
        return changed;
    }

    private static boolean shiftItemStackToRangeOpenSlots(List inventorySlots, ItemStack stackToShift, int start, int count) {
        if (stackToShift == null || stackToShift.stackSize <= 0) {
            return false;
        }
        boolean changed = false;
        for (int slotIndex = start; stackToShift.stackSize > 0 && slotIndex < start + count; ++slotIndex) {
            Slot slot = (Slot)inventorySlots.get(slotIndex);
            ItemStack stackInSlot = slot.getStack();
            if (stackInSlot != null) continue;
            int max = Math.min(stackToShift.getMaxStackSize(), slot.getSlotStackLimit());
            stackInSlot = stackToShift.copy();
            stackInSlot.stackSize = Math.min(stackToShift.stackSize, max);
            stackToShift.stackSize -= stackInSlot.stackSize;
            slot.putStack(stackInSlot);
            slot.onSlotChanged();
            changed = true;
        }
        return changed;
    }

    private static boolean isInPlayerInventory(int slotIndex) {
        return slotIndex < 36;
    }

    private static boolean isInPlayerHotbar(int slotIndex) {
        return SlotUtil.isSlotInRange(slotIndex, 27, 36);
    }

    private static boolean shiftToPlayerInventory(List inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        boolean shifted = SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackInSlot, playerHotbarStart, 9);
        shifted |= SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackInSlot, 0, playerHotbarStart);
        shifted |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackInSlot, playerHotbarStart, 9);
        return shifted |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackInSlot, 0, playerHotbarStart);
    }

    private static boolean shiftToPlayerInventoryNoHotbar(List inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        return SlotUtil.shiftItemStackToRange(inventorySlots, stackInSlot, 0, playerHotbarStart);
    }

    private static boolean shiftToHotbar(List inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        return SlotUtil.shiftItemStackToRange(inventorySlots, stackInSlot, playerHotbarStart, 9);
    }

    private static boolean shiftToMachineInventory(List inventorySlots, ItemStack stackToShift, int numSlots) {
        boolean success = false;
        if (stackToShift.isStackable()) {
            success = SlotUtil.shiftToMachineInventory(inventorySlots, stackToShift, numSlots, true);
        }
        if (stackToShift.stackSize > 0) {
            success |= SlotUtil.shiftToMachineInventory(inventorySlots, stackToShift, numSlots, false);
        }
        return success;
    }

    private static boolean shiftToMachineInventory(List inventorySlots, ItemStack stackToShift, int numSlots, boolean mergeOnly) {
        for (int machineIndex = 36; machineIndex < numSlots; ++machineIndex) {
            SlotForestry slotForestry;
            Slot slot = (Slot)inventorySlots.get(machineIndex);
            if (mergeOnly && slot.getStack() == null || slot instanceof SlotForestry && (!(slotForestry = (SlotForestry)slot).canShift() || slotForestry.isPhantom()) || !slot.isItemValid(stackToShift) || !SlotUtil.shiftItemStackToRange(inventorySlots, stackToShift, machineIndex, 1)) continue;
            return true;
        }
        return false;
    }
}

