/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.circuits.ISocketable;
import forestry.core.gui.ContainerLiquidTanksHelper;
import forestry.core.gui.ContainerSocketedHelper;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.gui.IContainerSocketed;
import forestry.core.tiles.ILiquidTankTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.IFluidTank;

public abstract class ContainerLiquidTanksSocketed<T extends TileEntity & ISocketable>
extends ContainerTile<T>
implements IContainerSocketed,
IContainerLiquidTanks {
    private final ContainerSocketedHelper<T> socketedHelper;
    private final ContainerLiquidTanksHelper<T> tanksHelper;

    protected ContainerLiquidTanksSocketed(T tile, InventoryPlayer playerInventory, int xInv, int yInv) {
        super(tile, playerInventory, xInv, yInv);
        this.socketedHelper = new ContainerSocketedHelper<T>(tile);
        this.tanksHelper = new ContainerLiquidTanksHelper<T>(tile);
    }

    @Override
    public void handlePipetteClickClient(int slot, EntityPlayer player) {
        this.tanksHelper.handlePipetteClickClient(slot, player);
    }

    @Override
    public void handlePipetteClick(int slot, EntityPlayerMP player) {
        this.tanksHelper.handlePipetteClick(slot, player);
    }

    public void updateProgressBar(int messageId, int data) {
        super.updateProgressBar(messageId, data);
        ((ILiquidTankTile)this.tile).getGUINetworkData(messageId, data);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        ((ILiquidTankTile)this.tile).getTankManager().updateGuiData(this, this.crafters);
        for (Object crafter : this.crafters) {
            ((ILiquidTankTile)this.tile).sendGUINetworkData(this, (ICrafting)crafter);
        }
    }

    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        ((ILiquidTankTile)this.tile).getTankManager().containerAdded(this, icrafting);
    }

    public void onContainerClosed(EntityPlayer entityPlayer) {
        super.onContainerClosed(entityPlayer);
        ((ILiquidTankTile)this.tile).getTankManager().containerRemoved(this);
    }

    @Override
    public IFluidTank getTank(int slot) {
        return ((ILiquidTankTile)this.tile).getTankManager().getTank(slot);
    }

    @Override
    public void handleChipsetClick(int slot) {
        this.socketedHelper.handleChipsetClick(slot);
    }

    @Override
    public void handleChipsetClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
        this.socketedHelper.handleChipsetClickServer(slot, player, itemstack);
    }

    @Override
    public void handleSolderingIronClick(int slot) {
        this.socketedHelper.handleSolderingIronClick(slot);
    }

    @Override
    public void handleSolderingIronClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
        this.socketedHelper.handleSolderingIronClickServer(slot, player, itemstack);
    }
}

