/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.genetics.Tree;
import forestry.core.access.IOwnable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketTileStream;
import forestry.core.utils.PlayerUtil;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileTreeContainer
extends TileEntity
implements IStreamable,
IOwnable {
    private ITree containedTree;
    private GameProfile owner;

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("ContainedTree")) {
            this.containedTree = new Tree(nbttagcompound.getCompoundTag("ContainedTree"));
        }
        if (nbttagcompound.hasKey("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.getCompoundTag("owner"));
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.containedTree != null) {
            NBTTagCompound subcompound = new NBTTagCompound();
            this.containedTree.writeToNBT(subcompound);
            nbttagcompound.setTag("ContainedTree", (NBTBase)subcompound);
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            nbttagcompound.setTag("owner", (NBTBase)nbt);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        String speciesUID = "";
        ITree tree = this.getTree();
        if (tree != null) {
            speciesUID = tree.getIdent();
        }
        data.writeUTF(speciesUID);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        String speciesUID = data.readUTF();
        ITree tree = TileTreeContainer.getTree(speciesUID);
        this.setTree(tree);
    }

    private static ITree getTree(String speciesUID) {
        IAllele[] treeTemplate = TreeManager.treeRoot.getTemplate(speciesUID);
        if (treeTemplate == null) {
            return null;
        }
        return TreeManager.treeRoot.templateAsIndividual(treeTemplate);
    }

    public void setTree(ITree tree) {
        this.containedTree = tree;
        if (this.worldObj != null && this.worldObj.isRemote) {
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public ITree getTree() {
        return this.containedTree;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return player != null && PlayerUtil.isSameGameProfile(player.getGameProfile(), this.owner);
    }

    public boolean canUpdate() {
        return false;
    }

    public abstract void onBlockTick();

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return !Block.isEqualTo((Block)oldBlock, (Block)newBlock);
    }

    public Packet getDescriptionPacket() {
        return new PacketTileStream(this).getPacket();
    }
}

