/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISpeedUpgradable;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.PlayerUtil;
import forestry.factory.recipes.SqueezerRecipeManager;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class TileSqueezer
extends TilePowered
implements ISocketable,
ISidedInventory,
ILiquidTankTile,
ISpeedUpgradable {
    private static final int TICKS_PER_RECIPE_TIME = 4;
    private static final int ENERGY_PER_RECIPE_TIME = 200;
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final TankManager tankManager;
    private final StandardTank productTank;
    private final SqueezerInventory inventory = new SqueezerInventory(this);
    private ISqueezerRecipe currentRecipe;

    public TileSqueezer() {
        super(1100, 4000, 2000);
        this.setInternalInventory(this.inventory);
        this.setHints(Config.hints.get("squeezer"));
        this.productTank = new StandardTank(10000);
        this.productTank.tankMode = StandardTank.TankMode.OUTPUT;
        this.tankManager = new TankManager(this, this.productTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.SqueezerGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.tankManager.writeTanksToNBT(nbttagcompound);
        this.sockets.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        ICircuitBoard chipset;
        super.readFromNBT(nbttagcompound);
        this.tankManager.readTanksFromNBT(nbttagcompound);
        this.sockets.readFromNBT(nbttagcompound);
        ItemStack chip = this.sockets.getStackInSlot(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readPacketData(data);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        super.writeGuiData(data);
        this.sockets.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        super.readGuiData(data);
        this.sockets.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            this.inventory.fillContainers(this.productTank.getFluid(), this.tankManager);
        }
    }

    @Override
    public boolean workCycle() {
        EntityPlayer player = PlayerUtil.getPlayer(this.worldObj, this.getAccessHandler().getOwner());
        if (!this.inventory.removeResources(this.currentRecipe.getResources(), player)) {
            return false;
        }
        FluidStack resultFluid = this.currentRecipe.getFluidOutput();
        this.productTank.fill(resultFluid, true);
        if (this.currentRecipe.getRemnants() != null && this.worldObj.rand.nextFloat() < this.currentRecipe.getRemnantsChance()) {
            ItemStack remnant = this.currentRecipe.getRemnants().copy();
            this.inventory.addRemnant(remnant, true);
        }
        return true;
    }

    private boolean checkRecipe() {
        ISqueezerRecipe matchingRecipe = null;
        if (this.inventory.hasResources()) {
            ItemStack[] resources = this.inventory.getResources();
            matchingRecipe = this.currentRecipe != null && ItemStackUtil.containsSets(this.currentRecipe.getResources(), resources, true, false) > 0 ? this.currentRecipe : SqueezerRecipeManager.findMatchingRecipe(resources);
        }
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
            if (this.currentRecipe != null) {
                int recipeTime = this.currentRecipe.getProcessingTime();
                this.setTicksPerWorkCycle(recipeTime * 4);
                this.setEnergyPerWorkCycle(recipeTime * 200);
            }
        }
        this.getErrorLogic().setCondition(this.currentRecipe == null, EnumErrorCode.NORECIPE);
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        boolean hasResources = this.inventory.hasResources();
        boolean hasRecipe = true;
        boolean canFill = true;
        boolean canAdd = true;
        if (hasResources) {
            boolean bl = hasRecipe = this.currentRecipe != null;
            if (hasRecipe) {
                FluidStack resultFluid = this.currentRecipe.getFluidOutput();
                boolean bl2 = canFill = this.productTank.fill(resultFluid, false) == resultFluid.amount;
                if (this.currentRecipe.getRemnants() != null) {
                    canAdd = this.inventory.addRemnant(this.currentRecipe.getRemnants(), false);
                }
            }
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasResources, EnumErrorCode.NORESOURCE);
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NORECIPE);
        errorLogic.setCondition(!canFill, EnumErrorCode.NOSPACETANK);
        errorLogic.setCondition(!canAdd, EnumErrorCode.NOSPACE);
        return hasResources && hasRecipe && canFill && canAdd;
    }

    public int getProductScaled(int i) {
        return this.productTank.getFluidAmount() * i / 10000;
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void getGUINetworkData(int messageId, int data) {
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    public int getSocketCount() {
        return this.sockets.getSizeInventory();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.getStackInSlot(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.getStackInSlot(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.getStackInSlot(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(this.sockets.getStackInSlot(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.setInventorySlotContents(slot, stack);
        if (stack == null) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return CircuitSocketType.MACHINE;
    }

    public static class SqueezerInventory
    extends TileInventoryAdapter<TileSqueezer> {
        public static final short SLOT_RESOURCE_1 = 0;
        public static final short SLOTS_RESOURCE_COUNT = 9;
        public static final short SLOT_REMNANT = 9;
        public static final short SLOT_REMNANT_COUNT = 1;
        public static final short SLOT_CAN_INPUT = 10;
        public static final short SLOT_CAN_OUTPUT = 11;

        public SqueezerInventory(TileSqueezer squeezer) {
            super(squeezer, 12, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 10) {
                return FluidHelper.isEmptyContainer(itemStack);
            }
            if (slotIndex >= 0 && slotIndex < 9) {
                if (FluidHelper.isEmptyContainer(itemStack)) {
                    return false;
                }
                if (SqueezerRecipeManager.canUse(itemStack)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 9 || slotIndex == 11;
        }

        public boolean hasResources() {
            return !InventoryUtil.isEmpty((IInventory)this, 0, 9);
        }

        public ItemStack[] getResources() {
            return InventoryUtil.getStacks((IInventory)this, 0, 9);
        }

        public boolean removeResources(ItemStack[] stacks, EntityPlayer player) {
            return InventoryUtil.removeSets((IInventory)this, 1, stacks, 0, 9, player, false, true);
        }

        public boolean addRemnant(ItemStack remnant, boolean doAdd) {
            return InventoryUtil.tryAddStack((IInventory)this, remnant, 9, 1, true, doAdd);
        }

        public void fillContainers(FluidStack fluidStack, TankManager tankManager) {
            if (this.getStackInSlot(10) == null || fluidStack == null) {
                return;
            }
            FluidHelper.fillContainers(tankManager, (IInventory)this, 10, 11, fluidStack.getFluid());
        }
    }
}

