/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gui;

import forestry.core.gui.widgets.SocketWidget;
import forestry.core.render.EnumTankLevel;
import forestry.energy.gui.ContainerEngineTin;
import forestry.energy.gui.GuiEngine;
import forestry.energy.tiles.TileEngineElectric;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiEngineTin
extends GuiEngine<ContainerEngineTin, TileEngineElectric> {
    public GuiEngineTin(InventoryPlayer inventory, TileEngineElectric tile) {
        super("textures/gui/electricalengine.png", new ContainerEngineTin(inventory, tile), tile);
        this.widgetManager.add(new SocketWidget(this.widgetManager, 30, 40, tile, 0));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        TileEngineElectric engine = (TileEngineElectric)this.inventory;
        int storageHeight = engine.getStorageScaled(46);
        int storageMaxHeight = engine.getStorageScaled(100);
        EnumTankLevel rated = EnumTankLevel.rateTankLevel(storageMaxHeight);
        this.drawHealthMeter(this.guiLeft + 74, this.guiTop + 25, storageHeight, rated);
    }

    private void drawHealthMeter(int x, int y, int height, EnumTankLevel rated) {
        int i = 176 + rated.getLevelScaled(16);
        int k = 0;
        this.drawTexturedModalRect(x, y + 46 - height, i, k + 46 - height, 4, height);
    }
}

