/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.config.ForestryItem;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public final class FluidHelper {
    private FluidHelper() {
    }

    public static boolean handleRightClick(IFluidHandler tank, ForgeDirection side, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null) {
            return false;
        }
        ItemStack current = player.inventory.getCurrentItem();
        if (current != null) {
            ItemStack filled;
            FluidStack available;
            FluidStack liquid = FluidHelper.getFluidStackInContainer(current);
            if (fill && liquid != null) {
                int used = tank.fill(side, liquid, true);
                if (used > 0) {
                    if (!player.capabilities.isCreativeMode) {
                        ItemStack drainedContainer = FluidHelper.getDrainedContainer(current, used);
                        if (current.stackSize > 1) {
                            player.inventory.decrStackSize(player.inventory.currentItem, 1);
                            if (drainedContainer != null && !player.inventory.addItemStackToInventory(drainedContainer)) {
                                player.dropPlayerItemWithRandomChoice(drainedContainer, false);
                            }
                        } else {
                            player.inventory.setInventorySlotContents(player.inventory.currentItem, drainedContainer);
                        }
                        player.inventory.markDirty();
                    }
                    return true;
                }
            } else if (drain && (available = tank.drain(side, Integer.MAX_VALUE, false)) != null && (liquid = FluidHelper.getFluidStackInContainer(filled = FluidHelper.getFilledContainer(available, current))) != null) {
                if (current.stackSize > 1) {
                    if (!player.inventory.addItemStackToInventory(filled)) {
                        return false;
                    }
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, InventoryUtil.depleteItem(current));
                    player.inventory.markDirty();
                } else {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, InventoryUtil.depleteItem(current));
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, filled);
                    player.inventory.markDirty();
                }
                tank.drain(side, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        return FluidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill, true);
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean doFill) {
        boolean moveToOutput;
        FluidStack canDrain;
        if (fluidToFill == null) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack input = inv.getStackInSlot(inputSlot);
        if (input == null) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack output = inv.getStackInSlot(outputSlot);
        int containerCapacity = FluidHelper.getFluidCapacity(fluidToFill, input);
        if (containerCapacity <= 0) {
            return FillStatus.INVALID_INPUT;
        }
        int fillAmount = containerCapacity;
        if (input.getItem() instanceof IFluidContainerItem) {
            fillAmount = Math.min(1000, containerCapacity);
        }
        if ((canDrain = fluidHandler.drain(ForgeDirection.UNKNOWN, new FluidStack(fluidToFill, fillAmount), false)) == null || canDrain.amount == 0) {
            return FillStatus.NO_FLUID;
        }
        ItemStack filled = FluidHelper.getFilledContainer(canDrain, input);
        if (filled == null) {
            return FillStatus.NO_FLUID;
        }
        boolean bl = moveToOutput = FluidHelper.getFluidStackInContainer((ItemStack)filled).amount >= containerCapacity;
        if (moveToOutput ? output != null && (output.stackSize >= output.getMaxStackSize() || !InventoryUtil.isItemEqual(filled, output)) : input.stackSize > 1) {
            return FillStatus.NO_SPACE;
        }
        if (doFill) {
            fluidHandler.drain(ForgeDirection.UNKNOWN, canDrain, true);
            if (moveToOutput) {
                if (output == null) {
                    inv.setInventorySlotContents(outputSlot, filled);
                } else {
                    ++output.stackSize;
                }
                inv.decrStackSize(inputSlot, 1);
            } else {
                inv.setInventorySlotContents(inputSlot, filled);
            }
        }
        return FillStatus.SUCCESS;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int slot) {
        return FluidHelper.drainContainers(fluidHandler, inv, slot, slot);
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot) {
        Item item;
        int used;
        ItemStack drainedItem;
        ItemStack input = inv.getStackInSlot(inputSlot);
        ItemStack output = inv.getStackInSlot(outputSlot);
        if (input == null) {
            return false;
        }
        FluidStack fluidInContainer = FluidHelper.getFluidStackInContainer(input);
        if (fluidInContainer == null) {
            return false;
        }
        if (input.getItem() instanceof IFluidContainerItem && fluidInContainer.amount > 1000) {
            fluidInContainer.amount = 1000;
        }
        if (ItemStack.areItemStacksEqual((ItemStack)input, (ItemStack)(drainedItem = FluidHelper.getDrainedContainer(input, used = fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, false))))) {
            return false;
        }
        if (outputSlot == inputSlot && drainedItem != null && (ForestryItem.canEmpty.isItemEqual(item = drainedItem.getItem()) || ForestryItem.waxCapsule.isItemEqual(item) || ForestryItem.refractoryEmpty.isItemEqual(item))) {
            drainedItem = null;
        }
        if (!FluidHelper.hasRoomForDrainedContainer(input, output, drainedItem, inputSlot, outputSlot)) {
            return false;
        }
        fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, true);
        if (drainedItem != null) {
            if (outputSlot == inputSlot) {
                inv.setInventorySlotContents(outputSlot, drainedItem);
                return true;
            }
            if (output == null) {
                inv.setInventorySlotContents(outputSlot, drainedItem);
            } else {
                ++output.stackSize;
            }
        }
        inv.decrStackSize(inputSlot, 1);
        return true;
    }

    private static boolean hasRoomForDrainedContainer(ItemStack input, ItemStack output, ItemStack drainedItem, int inputSlot, int outputSlot) {
        if (output == null || drainedItem == null) {
            return true;
        }
        if (outputSlot == inputSlot) {
            return input.stackSize == 1;
        }
        if (!ItemStackUtil.isIdenticalItem(output, drainedItem)) {
            return false;
        }
        return output.stackSize + drainedItem.stackSize <= output.getMaxStackSize();
    }

    public static boolean isEmptyContainer(ItemStack empty) {
        Item item = empty.getItem();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            FluidStack fluid = containerItem.getFluid(empty);
            return fluid == null || fluid.amount == 0;
        }
        return FluidContainerRegistry.isEmptyContainer((ItemStack)empty);
    }

    public static boolean isFillableContainer(ItemStack container) {
        FluidStack fluid = FluidHelper.getFluidStackInContainer(container);
        if (fluid == null || fluid.amount == 0) {
            return FluidHelper.isEmptyContainer(container);
        }
        int capacity = FluidHelper.getFluidCapacity(fluid.getFluid(), container);
        return fluid.amount < capacity;
    }

    public static ItemStack getDrainedContainer(ItemStack container, int drainAmount) {
        if (container == null) {
            return null;
        }
        if (drainAmount == 0) {
            return container;
        }
        Item item = container.getItem();
        if (item == null) {
            return null;
        }
        if (item instanceof IFluidContainerItem) {
            ItemStack drained = container.copy();
            drained.stackSize = 1;
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            containerItem.drain(drained, drainAmount, true);
            return drained;
        }
        int capacity = FluidContainerRegistry.getContainerCapacity((ItemStack)container);
        if (capacity > 0) {
            if (drainAmount < capacity) {
                return container;
            }
            return FluidContainerRegistry.drainFluidContainer((ItemStack)container);
        }
        return null;
    }

    public static ItemStack getEmptyContainer(ItemStack container) {
        if (container == null) {
            return null;
        }
        FluidStack fluidStack = FluidHelper.getFluidStackInContainer(container);
        if (fluidStack == null) {
            return null;
        }
        return FluidHelper.getDrainedContainer(container, fluidStack.amount);
    }

    public static List<ItemStack> getAllFilledContainers(ItemStack empty) {
        ArrayList<ItemStack> filledContainers = new ArrayList<ItemStack>();
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            ItemStack filledContainer = FluidHelper.getFilledContainer(fluid, empty);
            if (filledContainer == null) continue;
            filledContainers.add(filledContainer);
        }
        return filledContainers;
    }

    public static ItemStack getFilledContainer(Fluid fluid, ItemStack empty) {
        if (fluid == null) {
            return null;
        }
        FluidStack fluidToFill = new FluidStack(fluid, Integer.MAX_VALUE);
        return FluidHelper.getFilledContainer(fluidToFill, empty);
    }

    public static ItemStack getFilledContainer(FluidStack liquid, ItemStack empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        Item item = empty.getItem();
        if (item instanceof IFluidContainerItem) {
            ItemStack full = ItemStackUtil.createSplitStack(empty, 1);
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            containerItem.fill(full, liquid, true);
            return full;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)empty);
    }

    public static FluidStack getFluidStackInContainer(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.getItem();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            return containerItem.getFluid(stack);
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
    }

    public static Fluid getFluidInContainer(ItemStack stack) {
        FluidStack fluidStack = FluidHelper.getFluidStackInContainer(stack);
        return fluidStack != null ? fluidStack.getFluid() : null;
    }

    public static boolean containsFluidStack(ItemStack stack, FluidStack fluidStack) {
        Item item = stack.getItem();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            FluidStack contained = containerItem.getFluid(stack);
            return contained != null && contained.containsFluid(fluidStack);
        }
        return FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)fluidStack);
    }

    public static boolean containsFluid(ItemStack stack, Fluid fluid) {
        return FluidHelper.containsFluidStack(stack, new FluidStack(fluid, 1));
    }

    public static int getFluidCapacity(Fluid fluid, ItemStack container) {
        if (container == null) {
            return 0;
        }
        Item item = container.getItem();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            return containerItem.getCapacity(container);
        }
        if (fluid == null) {
            return FluidContainerRegistry.getContainerCapacity((ItemStack)container);
        }
        return FluidContainerRegistry.getContainerCapacity((FluidStack)new FluidStack(fluid, 1000), (ItemStack)container);
    }

    public static enum FillStatus {
        SUCCESS,
        INVALID_INPUT,
        NO_FLUID,
        NO_SPACE;

    }
}

