/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumWoodType;
import forestry.core.render.TextureManager;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public abstract class IconProviderWood {
    @SideOnly(value=Side.CLIENT)
    private static IIcon[][] icons;

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister register) {
        icons = new IIcon[3][EnumWoodType.VALUES.length];
        for (int i = 0; i < EnumWoodType.VALUES.length; ++i) {
            EnumWoodType woodType = EnumWoodType.VALUES[i];
            String woodName = woodType.toString().toLowerCase(Locale.ENGLISH);
            IconProviderWood.icons[0][i] = TextureManager.registerTex(register, "wood/planks." + woodName);
            IconProviderWood.icons[1][i] = TextureManager.registerTex(register, "wood/bark." + woodName);
            IconProviderWood.icons[2][i] = TextureManager.registerTex(register, "wood/heart." + woodName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getPlankIcon(EnumWoodType woodType) {
        return icons[0][woodType.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getBarkIcon(EnumWoodType woodType) {
        return icons[1][woodType.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getHeartIcon(EnumWoodType woodType) {
        return icons[2][woodType.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getLogIcon(EnumWoodType woodType, int meta, int side) {
        int oriented = meta & 0xC;
        switch (oriented) {
            case 4: {
                if (side > 3) {
                    return IconProviderWood.getHeartIcon(woodType);
                }
                return IconProviderWood.getBarkIcon(woodType);
            }
            case 8: {
                if (side == 2 || side == 3) {
                    return IconProviderWood.getHeartIcon(woodType);
                }
                return IconProviderWood.getBarkIcon(woodType);
            }
        }
        if (side < 2) {
            return IconProviderWood.getHeartIcon(woodType);
        }
        return IconProviderWood.getBarkIcon(woodType);
    }
}

