/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import javax.annotation.Nonnull;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.util.ForgeDirection;

public class CoordTriplet
implements Comparable {
    public int x;
    public int y;
    public int z;

    public CoordTriplet(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getChunkX() {
        return this.x >> 4;
    }

    public int getChunkZ() {
        return this.z >> 4;
    }

    public long getChunkXZHash() {
        return ChunkCoordIntPair.chunkXZ2Int((int)(this.x >> 4), (int)(this.z >> 4));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof CoordTriplet) {
            CoordTriplet otherTriplet = (CoordTriplet)other;
            return this.x == otherTriplet.x && this.y == otherTriplet.y && this.z == otherTriplet.z;
        }
        return false;
    }

    public void translate(ForgeDirection dir) {
        this.x += dir.offsetX;
        this.y += dir.offsetY;
        this.z += dir.offsetZ;
    }

    public boolean equals(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.x;
        hash = 71 * hash + this.y;
        hash = 71 * hash + this.z;
        return hash;
    }

    public CoordTriplet copy() {
        return new CoordTriplet(this.x, this.y, this.z);
    }

    public void copy(CoordTriplet other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public int compareTo(@Nonnull Object o) {
        if (o instanceof CoordTriplet) {
            CoordTriplet other = (CoordTriplet)o;
            if (this.x < other.x) {
                return -1;
            }
            if (this.x > other.x) {
                return 1;
            }
            if (this.y < other.y) {
                return -1;
            }
            if (this.y > other.y) {
                return 1;
            }
            if (this.z < other.z) {
                return -1;
            }
            if (this.z > other.z) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public String toString() {
        return String.format("(%d, %d, %d)", this.x, this.y, this.z);
    }

    public int compareTo(int xCoord, int yCoord, int zCoord) {
        if (this.x < xCoord) {
            return -1;
        }
        if (this.x > xCoord) {
            return 1;
        }
        if (this.y < yCoord) {
            return -1;
        }
        if (this.y > yCoord) {
            return 1;
        }
        if (this.z < zCoord) {
            return -1;
        }
        if (this.z > zCoord) {
            return 1;
        }
        return 0;
    }
}

