/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.BiomeHelper;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TileBase;
import forestry.core.utils.ItemStackUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileRaintank
extends TileBase
implements ISidedInventory,
ILiquidTankTile {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    private static final FluidStack STACK_WATER = Fluids.WATER.getFluid(10);
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private boolean isValidBiome = true;
    private int fillingTime;
    private ItemStack usedEmpty;

    public TileRaintank() {
        this.setInternalInventory(new RaintankInventoryAdapter(this));
        this.setHints(Config.hints.get("raintank"));
        this.resourceTank = new FilteredTank(30000, FluidRegistry.WATER);
        this.tankManager = new TankManager(this.resourceTank);
    }

    @Override
    public void validate() {
        if (this.worldObj != null) {
            BiomeGenBase biome = this.worldObj.getBiomeGenForCoordsBody(this.xCoord, this.zCoord);
            this.isValidBiome = BiomeHelper.canRainOrSnow(biome);
            this.getErrorLogic().setCondition(!this.isValidBiome, EnumErrorCode.INVALIDBIOME);
        }
        super.validate();
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.RaintankGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("IsValidBiome", this.isValidBiome);
        this.tankManager.writeTanksToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.isValidBiome = nbttagcompound.getBoolean("IsValidBiome");
        this.tankManager.readTanksFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readPacketData(data);
    }

    @Override
    public void updateServerSide() {
        if (!this.updateOnInterval(20)) {
            return;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!this.isValidBiome, EnumErrorCode.INVALIDBIOME);
        boolean hasSky = this.worldObj.canBlockSeeTheSky(this.xCoord, this.yCoord + 1, this.zCoord);
        errorLogic.setCondition(!hasSky, EnumErrorCode.NOSKY);
        errorLogic.setCondition(!this.worldObj.isRaining(), EnumErrorCode.NOTRAINING);
        if (!errorLogic.hasErrors()) {
            this.resourceTank.fill(STACK_WATER, true);
        }
        if (!ItemStackUtil.isIdenticalItem(this.usedEmpty, this.getStackInSlot(0))) {
            this.fillingTime = 0;
            this.usedEmpty = null;
        }
        if (this.usedEmpty == null) {
            this.usedEmpty = this.getStackInSlot(0);
        }
        if (!this.isFilling()) {
            this.tryToStartFillling();
        } else {
            --this.fillingTime;
            if (this.fillingTime <= 0 && FluidHelper.fillContainers(this.tankManager, (IInventory)this, 0, 1, Fluids.WATER.getFluid())) {
                this.fillingTime = 0;
            }
        }
    }

    public boolean isFilling() {
        return this.fillingTime > 0;
    }

    private void tryToStartFillling() {
        if (!FluidHelper.fillContainers(this.tankManager, (IInventory)this.getInternalInventory(), 0, 1, Fluids.WATER.getFluid(), false)) {
            return;
        }
        this.fillingTime = 12;
    }

    public int getFillProgressScaled(int i) {
        return this.fillingTime * i / 12;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.fillingTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.sendProgressBarUpdate(container, i, this.fillingTime);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class RaintankInventoryAdapter
    extends TileInventoryAdapter<TileRaintank> {
        public RaintankInventoryAdapter(TileRaintank raintank) {
            super(raintank, 3, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return FluidHelper.getFilledContainer(Fluids.WATER.getFluid(1000), itemStack) != null;
            }
            return false;
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 1;
        }
    }
}

