/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.core.recipes.ShapelessRecipeCustom;
import forestry.core.recipes.nei.INBTMatchingCachedRecipe;
import forestry.core.recipes.nei.NEIUtils;
import forestry.core.recipes.nei.RecipeHandlerBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class NEIHandlerShapelessCustom
extends RecipeHandlerBase {
    private static final int[][] OUTPUTS = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (Object recipe : CraftingManager.getInstance().getRecipeList()) {
            if (!(recipe instanceof ShapelessRecipeCustom) || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ShapelessRecipeCustom)recipe).getRecipeOutput(), (ItemStack)result)) continue;
            CachedShapelessCustomRecipe crecipe = new CachedShapelessCustomRecipe((ShapelessRecipeCustom)recipe);
            NEIUtils.setResultPermutationNBT(crecipe, result);
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object recipe : CraftingManager.getInstance().getRecipeList()) {
            if (!(recipe instanceof ShapelessRecipeCustom)) continue;
            CachedShapelessCustomRecipe crecipe = new CachedShapelessCustomRecipe((ShapelessRecipeCustom)recipe);
            if (crecipe.inputs == null || !crecipe.contains(crecipe.inputs, ingredient)) continue;
            NEIUtils.setIngredientPermutationNBT(crecipe, ingredient);
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public String getRecipeID() {
        return "crafting";
    }

    public String getOverlayIdentifier() {
        return "crafting";
    }

    public String getRecipeName() {
        return NEIUtils.translate("handler.forestry.shapeless");
    }

    public String getGuiTexture() {
        return "minecraft:textures/gui/container/crafting_table.png";
    }

    public class CachedShapelessCustomRecipe
    extends RecipeHandlerBase.CachedBaseRecipe
    implements INBTMatchingCachedRecipe {
        private final boolean preservesNbt;
        public List<PositionedStack> inputs;
        public PositionedStack output;

        public CachedShapelessCustomRecipe(ShapelessRecipeCustom recipe) {
            super(NEIHandlerShapelessCustom.this);
            this.inputs = new ArrayList<PositionedStack>();
            if (recipe.getIngredients() != null && recipe.getIngredients().size() > 0) {
                this.setIngredients(recipe.getIngredients());
            }
            if (recipe.getRecipeOutput() != null) {
                ItemStack output = recipe.getRecipeOutput();
                this.output = new PositionedStack((Object)output, 119, 24);
            }
            this.preservesNbt = recipe.preservesNbt();
        }

        public void setIngredients(List<ItemStack> items) {
            for (int i = 0; i < items.size(); ++i) {
                ItemStack item = items.get(i);
                if (item == null) continue;
                PositionedStack stack = new PositionedStack((Object)item, 25 + OUTPUTS[i][0] * 18, 6 + OUTPUTS[i][1] * 18);
                stack.setMaxSize(1);
                this.inputs.add(stack);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIHandlerShapelessCustom.this.cycleticks / 20, this.inputs);
        }

        @Override
        public boolean preservesNBT() {
            return this.preservesNbt;
        }

        @Override
        public PositionedStack getResult() {
            return this.output;
        }
    }
}

