/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.fluids.Fluids;
import forestry.core.fluids.ITankManager;
import forestry.core.fluids.tanks.FakeTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.network.PacketProgressBarUpdate;
import forestry.core.network.PacketTankLevelUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.render.EnumTankLevel;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.utils.NBTUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class TankManager
implements ITankManager {
    private static final byte NETWORK_DATA = 3;
    private final List<StandardTank> tanks = new ArrayList<StandardTank>();
    private final List<EnumTankLevel> tankLevels = new ArrayList<EnumTankLevel>();
    private final List<FluidStack> prevFluidStacks = new ArrayList<FluidStack>();
    private final List<Integer> prevColor = new ArrayList<Integer>();
    @Nullable
    private final ILiquidTankTile tile;

    public TankManager() {
        this.tile = null;
    }

    public TankManager(StandardTank ... tanks) {
        this((ILiquidTankTile)null, tanks);
    }

    public TankManager(@Nullable ILiquidTankTile tile, StandardTank ... tanks) {
        this.tile = tile;
        this.addAll(Arrays.asList(tanks));
    }

    public final boolean addAll(@Nonnull Collection<? extends StandardTank> collection) {
        boolean addedAll = true;
        for (StandardTank standardTank : collection) {
            addedAll &= this.add(standardTank);
        }
        return addedAll;
    }

    public boolean add(@Nonnull StandardTank tank) {
        boolean added = this.tanks.add(tank);
        int index = this.tanks.indexOf((Object)tank);
        tank.setTankIndex(index);
        this.tankLevels.add(EnumTankLevel.rateTankLevel((IFluidTank)tank));
        this.prevFluidStacks.add(tank.getFluid() == null ? null : tank.getFluid().copy());
        this.prevColor.add(tank.getColor());
        return added;
    }

    public int maxMessageId() {
        return 3 * this.tanks.size();
    }

    public void writeTanksToNBT(NBTTagCompound data) {
        NBTTagList tagList = new NBTTagList();
        for (byte slot = 0; slot < this.tanks.size(); slot = (byte)((byte)(slot + 1))) {
            StandardTank tank = this.tanks.get(slot);
            if (tank.getFluid() == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.setByte("tank", slot);
            tank.writeToNBT(tag);
            tagList.appendTag((NBTBase)tag);
        }
        data.setTag("tanks", (NBTBase)tagList);
    }

    public void readTanksFromNBT(NBTTagCompound data) {
        NBTUtil.NBTList tagList = NBTUtil.getNBTList(data, "tanks", NBTUtil.EnumNBTType.COMPOUND);
        Iterator i$ = tagList.iterator();
        while (i$.hasNext()) {
            NBTTagCompound tag = (NBTTagCompound)i$.next();
            byte slot = tag.getByte("tank");
            if (slot < 0 || slot >= this.tanks.size()) continue;
            StandardTank tank = this.tanks.get(slot);
            tank.readFromNBT(tag);
            this.updateTankLevels(tank, false);
        }
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        for (int i = 0; i < this.tanks.size(); ++i) {
            this.writePacketData(data, i);
        }
    }

    public void writePacketData(DataOutputStream data, int tankIndex) throws IOException {
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack != null) {
            data.writeShort(fluidStack.getFluid().getID());
            data.writeInt(fluidStack.amount);
            data.writeInt(fluidStack.getFluid().getColor(fluidStack));
        } else {
            data.writeShort(-1);
        }
    }

    public void readPacketData(DataInputStream data) throws IOException {
        for (int i = 0; i < this.tanks.size(); ++i) {
            this.readPacketData(data, i);
        }
    }

    public void readPacketData(DataInputStream data, int tankIndex) throws IOException {
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        short fluidId = data.readShort();
        Fluid fluid = FluidRegistry.getFluid((int)fluidId);
        if (fluid != null) {
            int amount = data.readInt();
            FluidStack fluidStack = new FluidStack(fluid, amount);
            tank.setFluid(fluidStack);
            tank.colorCache = data.readInt();
        } else {
            tank.setFluid(null);
        }
    }

    @Override
    public void initGuiData(Container container, ICrafting player) {
        for (StandardTank tank : this.tanks) {
            this.initGuiData(container, player, tank.getTankIndex());
        }
    }

    private void initGuiData(Container container, ICrafting player, int tankIndex) {
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        FluidStack fluidStack = this.tanks.get(tankIndex).getFluid();
        int fluidId = -1;
        int fluidAmount = 0;
        if (fluidStack != null && fluidStack.amount > 0) {
            fluidId = fluidStack.getFluid().getID();
            fluidAmount = fluidStack.amount;
        }
        player.sendProgressBarUpdate(container, tankIndex * 3, fluidId);
        PacketProgressBarUpdate packet = new PacketProgressBarUpdate(container.windowId, tankIndex * 3 + 1, fluidAmount);
        Proxies.net.sendToPlayer(packet, (EntityPlayer)((EntityPlayerMP)player));
    }

    @Override
    public void updateGuiData(Container container, List<EntityPlayerMP> crafters) {
        for (StandardTank tank : this.tanks) {
            this.updateGuiData(container, crafters, tank.getTankIndex());
        }
    }

    private void updateGuiData(Container container, List<EntityPlayerMP> crafters, int tankIndex) {
        StandardTank tank = this.tanks.get(tankIndex);
        FluidStack fluidStack = tank.getFluid();
        FluidStack prev = this.prevFluidStacks.get(tankIndex);
        int color = tank.getColor();
        int pColor = this.prevColor.get(tankIndex);
        for (EntityPlayerMP player : crafters) {
            if (fluidStack == null ^ prev == null) {
                int fluidId = -1;
                int fluidAmount = 0;
                if (fluidStack != null) {
                    fluidId = fluidStack.getFluid().getID();
                    fluidAmount = fluidStack.amount;
                }
                player.sendProgressBarUpdate(container, tankIndex * 3, fluidId);
                PacketProgressBarUpdate packet = new PacketProgressBarUpdate(container.windowId, tankIndex * 3 + 1, fluidAmount);
                Proxies.net.sendToPlayer(packet, (EntityPlayer)player);
                continue;
            }
            if (fluidStack == null || prev == null) continue;
            if (fluidStack.getFluid() != prev.getFluid()) {
                player.sendProgressBarUpdate(container, tankIndex * 3, fluidStack.getFluid().getID());
            }
            if (fluidStack.amount != prev.amount) {
                PacketProgressBarUpdate packet = new PacketProgressBarUpdate(container.windowId, tankIndex * 3 + 1, fluidStack.amount);
                Proxies.net.sendToPlayer(packet, (EntityPlayer)player);
            }
            if (color == pColor) continue;
            PacketProgressBarUpdate packet = new PacketProgressBarUpdate(container.windowId, tankIndex * 3 + 2, color);
            Proxies.net.sendToPlayer(packet, (EntityPlayer)player);
        }
        this.prevFluidStacks.set(tankIndex, tank.getFluid() == null ? null : tank.getFluid().copy());
        this.prevColor.set(tankIndex, color);
    }

    @Override
    public void processGuiUpdate(int messageId, int data) {
        int tankIndex = messageId / 3;
        if (tankIndex >= this.tanks.size()) {
            return;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        switch (messageId % 3) {
            case 0: {
                Fluid fluid = FluidRegistry.getFluid((int)data);
                if (fluid == null) break;
                FluidStack fluidStack = new FluidStack(fluid, 0);
                tank.setFluid(fluidStack);
                break;
            }
            case 1: {
                FluidStack fluidStack = tank.getFluid();
                if (fluidStack == null) break;
                fluidStack.amount = data;
                break;
            }
            case 2: {
                tank.colorCache = data;
            }
        }
    }

    @Override
    public void processTankUpdate(int tankIndex, FluidStack contents) {
        if (tankIndex < 0 || tankIndex > this.tanks.size()) {
            return;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        tank.setFluid(contents);
    }

    @Override
    public IFluidTank getTank(int tankIndex) {
        return (IFluidTank)this.tanks.get(tankIndex);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankAcceptsFluid(tank, resource)) continue;
            return this.fill(tank.getTankIndex(), resource, doFill);
        }
        return FakeTank.INSTANCE.fill(resource, doFill);
    }

    public int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size() || resource == null) {
            return 0;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        if (!tank.canBeFilledExternally()) {
            return 0;
        }
        int fill = tank.fill(resource, doFill);
        if (doFill) {
            this.updateTankLevels(tank, true);
        }
        return fill;
    }

    private void updateTankLevels(StandardTank tank, boolean sendUpdate) {
        if (this.tile == null) {
            return;
        }
        int tankIndex = tank.getTankIndex();
        EnumTankLevel tankLevel = EnumTankLevel.rateTankLevel((IFluidTank)tank);
        if (tankLevel != this.tankLevels.get(tankIndex)) {
            this.tankLevels.set(tankIndex, tankLevel);
            if (sendUpdate) {
                PacketTankLevelUpdate tankLevelUpdate = new PacketTankLevelUpdate(this.tile, tankIndex, tank.getFluid());
                Proxies.net.sendNetworkPacket(tankLevelUpdate, this.tile.getWorld());
            }
        }
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankCanDrain(tank, true)) continue;
            return this.drain(tank.getTankIndex(), maxDrain, true, doDrain);
        }
        return FakeTank.INSTANCE.drain(maxDrain, doDrain);
    }

    public FluidStack drain(int tankIndex, int maxDrain, boolean external, boolean doDrain) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return null;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        if (external && !tank.canBeDrainedExternally()) {
            return null;
        }
        FluidStack drained = tank.drain(maxDrain, doDrain);
        if (doDrain) {
            this.updateTankLevels(tank, true);
        }
        return drained;
    }

    public FluidStack drain(Fluid resource, int amount, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        return this.drain(new FluidStack(resource, amount), false, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.drain(resource, false, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean external, boolean doDrain) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankCanDrainFluid(tank, resource, external)) continue;
            return this.drain(tank.getTankIndex(), resource.amount, external, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(resource, true, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        FluidTankInfo[] info = new FluidTankInfo[this.tanks.size()];
        for (int i = 0; i < this.tanks.size(); ++i) {
            info[i] = this.tanks.get(i).getInfo();
        }
        return info;
    }

    public FluidTankInfo[] getTankInfo() {
        return this.getTankInfo(ForgeDirection.UNKNOWN);
    }

    public FluidTankInfo getTankInfo(int tankIndex) {
        return this.tanks.get(tankIndex).getInfo();
    }

    public FluidStack getFluid(int tankIndex) {
        return this.tanks.get(tankIndex).getFluid();
    }

    public int getFluidAmount(int tankIndex) {
        return this.tanks.get(tankIndex).getFluidAmount();
    }

    public boolean accepts(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        for (StandardTank tank : this.tanks) {
            if (!tank.accepts(fluid)) continue;
            return true;
        }
        return false;
    }

    private static boolean tankAcceptsFluid(StandardTank tank, FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        if (!tank.canBeFilledExternally()) {
            return false;
        }
        return tank.fill(fluidStack, false) > 0;
    }

    private static boolean tankCanDrain(StandardTank tank, boolean external) {
        if (external && !tank.canBeDrainedExternally()) {
            return false;
        }
        FluidStack drained = tank.drain(1, false);
        return drained != null && drained.amount > 0;
    }

    private static boolean tankCanDrainFluid(StandardTank tank, FluidStack fluidStack, boolean external) {
        if (fluidStack == null) {
            return false;
        }
        if (!Fluids.areEqual(tank.getFluidType(), fluidStack)) {
            return false;
        }
        return TankManager.tankCanDrain(tank, external);
    }
}

