/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.BeeHousingInventory;
import forestry.core.config.Config;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.TileBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class TileAbstractBeeHousing
extends TileBase
implements IBeeHousing,
IClimatised {
    private final IBeekeepingLogic beeLogic;
    private BiomeGenBase cachedBiome;
    private int breedingProgressPercent = 0;

    protected TileAbstractBeeHousing() {
        this.setHints(Config.hints.get("apiary"));
        this.beeLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.beeLogic.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.beeLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public Packet getDescriptionPacket() {
        this.beeLogic.syncToClient();
        return super.getDescriptionPacket();
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        return this.getBiome().getFloatTemperature(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().rainfall;
    }

    @Override
    public void updateClientSide() {
        if (this.beeLogic.canDoBeeFX() && this.updateOnInterval(4)) {
            this.beeLogic.doBeeFX();
            if (this.updateOnInterval(50)) {
                float fxX = (float)this.xCoord + 0.5f;
                float fxY = (float)this.yCoord + 0.25f;
                float fxZ = (float)this.zCoord + 0.5f;
                float distanceFromCenter = 0.6f;
                float leftRightSpreadFromCenter = distanceFromCenter * (this.worldObj.rand.nextFloat() - 0.5f);
                float upSpread = this.worldObj.rand.nextFloat() * 6.0f / 16.0f;
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX - distanceFromCenter, fxY += upSpread, fxZ + leftRightSpreadFromCenter);
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX + distanceFromCenter, fxY, fxZ + leftRightSpreadFromCenter);
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX + leftRightSpreadFromCenter, fxY, fxZ - distanceFromCenter);
                Proxies.render.addEntitySwarmFX(this.worldObj, fxX + leftRightSpreadFromCenter, fxY, fxZ + distanceFromCenter);
            }
        }
    }

    @Override
    public void updateServerSide() {
        if (this.beeLogic.canWork()) {
            this.beeLogic.doWork();
        }
    }

    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.breedingProgressPercent = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.sendProgressBarUpdate(container, 0, this.beeLogic.getBeeProgressPercent());
    }

    @Override
    public BiomeGenBase getBiome() {
        if (this.cachedBiome == null) {
            this.cachedBiome = this.worldObj.getBiomeGenForCoordsBody(this.xCoord, this.zCoord);
        }
        return this.cachedBiome;
    }

    @Override
    public int getBlockLightValue() {
        return this.worldObj.getBlockLightValue(this.xCoord, this.yCoord + 1, this.zCoord);
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.worldObj.canBlockSeeTheSky(this.xCoord, this.yCoord + 1, this.zCoord);
    }

    @Override
    public GameProfile getOwner() {
        return this.getAccessHandler().getOwner();
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    public static class TileBeeHousingInventory
    extends BeeHousingInventory {
        private final TileAbstractBeeHousing tile;

        public TileBeeHousingInventory(TileAbstractBeeHousing tile, int size, String name) {
            super(size, name, tile.getAccessHandler());
            this.tile = tile;
        }

        @Override
        public void markDirty() {
            super.markDirty();
            this.tile.markDirty();
        }
    }
}

