/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.apiculture.gui.ContainerAlveary;
import forestry.apiculture.gui.ContainerAlvearyHygroregulator;
import forestry.apiculture.gui.ContainerAlvearySieve;
import forestry.apiculture.gui.ContainerAlvearySwarmer;
import forestry.apiculture.gui.ContainerBeeHousing;
import forestry.apiculture.gui.ContainerHabitatLocator;
import forestry.apiculture.gui.ContainerImprinter;
import forestry.apiculture.gui.GuiAlveary;
import forestry.apiculture.gui.GuiAlvearyHygroregulator;
import forestry.apiculture.gui.GuiAlvearySieve;
import forestry.apiculture.gui.GuiAlvearySwarmer;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.gui.GuiBeealyzer;
import forestry.apiculture.gui.GuiHabitatLocator;
import forestry.apiculture.gui.GuiImprinter;
import forestry.apiculture.items.ItemBeealyzer;
import forestry.apiculture.items.ItemHabitatLocator;
import forestry.apiculture.items.ItemImprinter;
import forestry.apiculture.multiblock.TileAlvearyHygroregulator;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.apiculture.tiles.TileApiary;
import forestry.apiculture.tiles.TileBeehouse;
import forestry.core.GuiHandlerBase;
import forestry.core.gui.ContainerAlyzer;
import forestry.core.network.GuiId;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GuiHandlerApiculture
extends GuiHandlerBase {
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandlerApiculture.decodeGuiID(id);
        int guiData = GuiHandlerApiculture.decodeGuiData(id);
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[cleanId]) {
            case AlvearyGUI: {
                return new GuiAlveary(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileAlvearyPlain.class));
            }
            case AlvearySieveGUI: {
                return new GuiAlvearySieve(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileAlvearySieve.class));
            }
            case AlvearySwarmerGUI: {
                return new GuiAlvearySwarmer(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileAlvearySwarmer.class));
            }
            case ApiaristChestGUI: {
                return this.getNaturalistChestGui(BeeManager.beeRoot, player, world, x, y, z, guiData);
            }
            case ApiaryGUI: {
                return new GuiBeeHousing(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileApiary.class));
            }
            case BeealyzerGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                return new GuiBeealyzer(player, new ItemBeealyzer.BeealyzerInventory(player, equipped));
            }
            case BeehouseGUI: {
                return new GuiBeeHousing(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileBeehouse.class));
            }
            case HabitatLocatorGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                return new GuiHabitatLocator(player, new ItemHabitatLocator.HabitatLocatorInventory(player, equipped));
            }
            case HygroregulatorGUI: {
                return new GuiAlvearyHygroregulator(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileAlvearyHygroregulator.class));
            }
            case ImprinterGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                return new GuiImprinter(player.inventory, new ItemImprinter.ImprinterInventory(player, equipped));
            }
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandlerApiculture.decodeGuiID(id);
        int guiData = GuiHandlerApiculture.decodeGuiData(id);
        if (cleanId >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[cleanId]) {
            case AlvearyGUI: {
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                return new ContainerAlveary(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileAlvearyPlain.class));
            }
            case AlvearySieveGUI: {
                return new ContainerAlvearySieve(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileAlvearySieve.class));
            }
            case AlvearySwarmerGUI: {
                return new ContainerAlvearySwarmer(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileAlvearySwarmer.class));
            }
            case ApiaristChestGUI: {
                return this.getNaturalistChestContainer(BeeManager.beeRoot, player, world, x, y, z, guiData);
            }
            case ApiaryGUI: {
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                return new ContainerBeeHousing(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileApiary.class), true);
            }
            case BeealyzerGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                return new ContainerAlyzer(new ItemBeealyzer.BeealyzerInventory(player, equipped), player);
            }
            case BeehouseGUI: {
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                return new ContainerBeeHousing(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileBeehouse.class), false);
            }
            case HabitatLocatorGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                return new ContainerHabitatLocator(player, new ItemHabitatLocator.HabitatLocatorInventory(player, equipped));
            }
            case HygroregulatorGUI: {
                return new ContainerAlvearyHygroregulator(player.inventory, GuiHandlerApiculture.getTile(world, x, y, z, player, TileAlvearyHygroregulator.class));
            }
            case ImprinterGUI: {
                GuiHandlerApiculture.synchApiaristTracker(world, player);
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                return new ContainerImprinter(player.inventory, new ItemImprinter.ImprinterInventory(player, equipped));
            }
        }
        return null;
    }

    private static void synchApiaristTracker(World world, EntityPlayer player) {
        BeeManager.beeRoot.getBreedingTracker(world, player.getGameProfile()).synchToPlayer(player);
    }
}

