/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import com.mojang.authlib.GameProfile;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.BlockTypeVoid;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class WorldGenArboriculture
extends WorldGenBase {
    private static final ITreeBlockType vineNorth = new TreeBlockType(Blocks.vine, 1);
    private static final ITreeBlockType vineSouth = new TreeBlockType(Blocks.vine, 4);
    private static final ITreeBlockType vineWest = new TreeBlockType(Blocks.vine, 8);
    private static final ITreeBlockType vineEast = new TreeBlockType(Blocks.vine, 2);
    private static final int minPodHeight = 3;
    private static final BlockType air = new BlockTypeVoid();
    protected final ITreeGenData tree;
    private int startX;
    private int startY;
    private int startZ;
    protected TreeBlockTypeLeaf leaf;
    protected ITreeBlockType wood;
    private boolean spawnPods = false;

    protected WorldGenArboriculture(ITreeGenData tree) {
        this.tree = tree;
    }

    @Override
    public boolean generate(World world, int x, int y, int z, boolean forced) {
        this.spawnPods = this.tree.allowsFruitBlocks();
        this.leaf = this.getLeaf(WorldGenArboriculture.getOwner(world, x, y, z));
        this.wood = this.getWood();
        this.preGenerate(world, x, y, z);
        if (forced || this.canGrow(world, x, y, z)) {
            this.generate(world);
            return true;
        }
        return false;
    }

    private static GameProfile getOwner(World world, int x, int y, int z) {
        TileTreeContainer tile = TileUtil.getTile((IBlockAccess)world, x, y, z, TileTreeContainer.class);
        if (tile == null) {
            return null;
        }
        return tile.getOwner();
    }

    public void preGenerate(World world, int startX, int startY, int startZ) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
    }

    protected abstract void generate(World var1);

    public abstract boolean canGrow(World var1, int var2, int var3, int var4);

    protected abstract TreeBlockTypeLeaf getLeaf(GameProfile var1);

    protected abstract ITreeBlockType getWood();

    protected List<ChunkCoordinates> generateTreeTrunk(World world, int height, int girth) {
        return this.generateTreeTrunk(world, height, girth, 0.0f);
    }

    protected List<ChunkCoordinates> generateTreeTrunk(World world, int height, int girth, float vinesChance) {
        return this.generateTreeTrunk(world, height, girth, vinesChance, ForgeDirection.UNKNOWN, 0.0f);
    }

    protected List<ChunkCoordinates> generateTreeTrunk(World world, int height, int girth, float vinesChance, ForgeDirection leanDirection, float leanAmount) {
        return this.generateTreeTrunk(world, height, girth, 0, vinesChance, leanDirection, leanAmount);
    }

    protected List<ChunkCoordinates> generateTreeTrunk(World world, int height, int girth, int yStart, float vinesChance, ForgeDirection leanDirection, float leanAmount) {
        ArrayList<ChunkCoordinates> treeTops = new ArrayList<ChunkCoordinates>();
        int leanStartY = (int)Math.floor((float)height * 0.33f);
        int prevXOffset = 0;
        int prevZOffset = 0;
        int offset = (girth - 1) / 2;
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                for (int y = yStart; y < height; ++y) {
                    float lean = y < leanStartY ? 0.0f : leanAmount * (float)(y - leanStartY) / (float)(height - leanStartY);
                    int xOffset = (int)Math.floor((float)leanDirection.offsetX * lean - (float)offset);
                    int zOffset = (int)Math.floor((float)leanDirection.offsetZ * lean - (float)offset);
                    if (xOffset != prevXOffset || zOffset != prevZOffset) {
                        prevXOffset = xOffset;
                        prevZOffset = zOffset;
                        if (y > 0) {
                            this.wood.setDirection(leanDirection);
                            this.addWood(world, x + xOffset, y - 1, z + zOffset, WorldGenBase.EnumReplaceMode.ALL);
                            this.wood.setDirection(ForgeDirection.UP);
                        }
                    }
                    this.addWood(world, x + xOffset, y, z + zOffset, WorldGenBase.EnumReplaceMode.ALL);
                    this.addVines(world, x + xOffset, y, z + zOffset, vinesChance);
                    if (y + 1 != height) continue;
                    treeTops.add(new ChunkCoordinates(x + xOffset, y, z + zOffset));
                }
            }
        }
        if (this.spawnPods) {
            this.generatePods(world, height, girth);
        }
        return treeTops;
    }

    protected void generatePods(World world, int height, int girth) {
        for (int y = 3; y < height; ++y) {
            for (int x = 0; x < girth; ++x) {
                for (int z = 0; z < girth; ++z) {
                    if (x > 0 && x < girth && z > 0 && z < girth) continue;
                    this.trySpawnFruitBlock(world, x + 1, y, z);
                    this.trySpawnFruitBlock(world, x - 1, y, z);
                    this.trySpawnFruitBlock(world, x, y, z + 1);
                    this.trySpawnFruitBlock(world, x, y, z - 1);
                }
            }
        }
    }

    private void trySpawnFruitBlock(World world, int x, int y, int z) {
        if (BlockUtil.isReplaceableBlock(world, x += this.startX, y += this.startY, z += this.startZ) || world.isAirBlock(x, y, z)) {
            this.tree.trySpawnFruitBlock(world, x, y, z);
        }
    }

    protected void generateSupportStems(World world, int height, int girth, float chance, float maxHeight) {
        int offset = (int)Math.ceil((float)girth / 2.0f);
        int max = (int)Math.floor((float)girth / 2.0f) + offset;
        if (girth % 2 == 0) {
            ++max;
        }
        for (int x = -offset; x < max; ++x) {
            for (int z = -offset; z < max; ++z) {
                if (x == -offset && z == -offset || x == max && z == max || x == -offset && z == max || x == max && z == -offset) continue;
                int stemHeight = world.rand.nextInt(Math.round((float)height * maxHeight));
                if (!(world.rand.nextFloat() < chance)) continue;
                for (int i = 0; i < stemHeight; ++i) {
                    this.addWood(world, x, i, z, WorldGenBase.EnumReplaceMode.SOFT);
                }
            }
        }
    }

    protected List<ChunkCoordinates> generateBranches(World world, int startY, int xOffset, int zOffset, float spreadY, float spreadXZ, int radius, int count) {
        return this.generateBranches(world, startY, xOffset, zOffset, spreadY, spreadXZ, radius, count, 1.0f);
    }

    protected List<ChunkCoordinates> generateBranches(World world, int startY, int xOffset, int zOffset, float spreadY, float spreadXZ, int radius, int count, float chance) {
        ArrayList<ChunkCoordinates> branchEnds = new ArrayList<ChunkCoordinates>();
        if (radius < 1) {
            radius = 1;
        }
        for (Direction cardinalDirection : Direction.values()) {
            ForgeDirection branchDirection = cardinalDirection.forgeDirection;
            this.wood.setDirection(branchDirection);
            for (int i = 0; i < count; ++i) {
                if (world.rand.nextFloat() > chance) continue;
                int y = startY;
                int x = xOffset;
                int z = zOffset;
                for (int r = 0; r < radius; ++r) {
                    if (world.rand.nextFloat() < spreadY) {
                        ++y;
                    } else if (world.rand.nextFloat() < spreadXZ) {
                        if (branchDirection.offsetX == 0) {
                            x = world.rand.nextBoolean() ? ++x : --x;
                            this.wood.setDirection(ForgeDirection.EAST);
                        } else if (branchDirection.offsetZ == 0) {
                            z = world.rand.nextBoolean() ? ++z : --z;
                            this.wood.setDirection(ForgeDirection.SOUTH);
                        }
                    } else {
                        x += branchDirection.offsetX;
                        z += branchDirection.offsetZ;
                        this.wood.setDirection(branchDirection);
                    }
                    this.addWood(world, x, y, z, WorldGenBase.EnumReplaceMode.SOFT);
                    branchEnds.add(new ChunkCoordinates(x, y, z));
                }
            }
        }
        return branchEnds;
    }

    @Override
    protected void addBlock(World world, int x, int y, int z, ITreeBlockType type, WorldGenBase.EnumReplaceMode replace) {
        if (replace == WorldGenBase.EnumReplaceMode.ALL || replace == WorldGenBase.EnumReplaceMode.SOFT && BlockUtil.isReplaceableBlock(world, this.startX + x, this.startY + y, this.startZ + z) || world.isAirBlock(this.startX + x, this.startY + y, this.startZ + z)) {
            type.setBlock(world, this.tree, this.startX + x, this.startY + y, this.startZ + z);
        }
    }

    protected final void clearBlock(World world, int x, int y, int z) {
        air.setBlock(world, this.startX + x, this.startY + y, this.startZ + z);
    }

    protected final void addWood(World world, int x, int y, int z, WorldGenBase.EnumReplaceMode replace) {
        this.addBlock(world, x, y, z, this.wood, replace);
    }

    protected final void addLeaf(World world, int x, int y, int z, WorldGenBase.EnumReplaceMode replace) {
        this.addBlock(world, x, y, z, this.leaf, replace);
    }

    protected final void addVine(World world, int x, int y, int z, ITreeBlockType vine) {
        this.addBlock(world, x, y, z, vine, WorldGenBase.EnumReplaceMode.NONE);
    }

    protected final void addVines(World world, int x, int y, int z, float chance) {
        if (chance <= 0.0f) {
            return;
        }
        if (world.rand.nextFloat() < chance) {
            this.addVine(world, x - 1, y, z, vineWest);
        }
        if (world.rand.nextFloat() < chance) {
            this.addVine(world, x + 1, y, z, vineEast);
        }
        if (world.rand.nextFloat() < chance) {
            this.addVine(world, x, y, z - 1, vineNorth);
        }
        if (world.rand.nextFloat() < chance) {
            this.addVine(world, x, y, z + 1, vineSouth);
        }
    }

    static enum Direction {
        NORTH(ForgeDirection.NORTH),
        SOUTH(ForgeDirection.SOUTH),
        WEST(ForgeDirection.WEST),
        EAST(ForgeDirection.EAST);

        public final ForgeDirection forgeDirection;

        private Direction(ForgeDirection forgeDirection) {
            this.forgeDirection = forgeDirection;
        }

        public static Direction getRandom(Random random) {
            return Direction.values()[random.nextInt(Direction.values().length)];
        }

        public static Direction getRandomOther(Random random, Direction direction) {
            EnumSet<Direction> directions = EnumSet.allOf(Direction.class);
            directions.remove((Object)direction);
            int size = directions.size();
            return directions.toArray(new Direction[size])[random.nextInt(size)];
        }
    }
}

