/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.network.IRipeningPacketReceiver;
import forestry.arboriculture.network.PacketRipeningUpdate;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketTileStream;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class TileFruitPod
extends TileEntity
implements IFruitBearer,
IStreamable,
IRipeningPacketReceiver {
    private static final short MAX_MATURITY = 2;
    private IAlleleFruit allele;
    private short maturity;
    private int[] indices = new int[0];
    private float sappiness;

    public void setFruit(IAlleleFruit allele, float sappiness, short[] indices) {
        this.allele = allele;
        this.sappiness = sappiness;
        this.indices = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            this.indices[i] = indices[i];
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        IAllele stored = AlleleManager.alleleRegistry.getAllele(nbttagcompound.getString("UID"));
        this.allele = stored != null && stored instanceof IAlleleFruit ? (IAlleleFruit)stored : (IAlleleFruit)AlleleManager.alleleRegistry.getAllele("fruitCocoa");
        this.maturity = nbttagcompound.getShort("MT");
        this.sappiness = nbttagcompound.getFloat("SP");
        this.indices = nbttagcompound.getIntArray("IN");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.allele != null) {
            nbttagcompound.setString("UID", this.allele.getUID());
        }
        nbttagcompound.setShort("MT", this.maturity);
        nbttagcompound.setFloat("SP", this.sappiness);
        nbttagcompound.setIntArray("IN", this.indices);
    }

    public boolean canUpdate() {
        return false;
    }

    public void onBlockTick() {
        if (this.canMature() && this.worldObj.rand.nextFloat() <= this.sappiness) {
            this.mature();
        }
    }

    public void mature() {
        this.maturity = (short)(this.maturity + 1);
        this.sendNetworkUpdateRipening();
    }

    public boolean canMature() {
        return this.maturity < 2;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        if (this.maturity < this.indices.length) {
            return TextureManager.getInstance().getIcon((short)this.indices[this.maturity]);
        }
        return null;
    }

    public short getMaturity() {
        return this.maturity;
    }

    public ItemStack[] getDrop() {
        return this.allele.getProvider().getFruits(null, this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.maturity);
    }

    public Packet getDescriptionPacket() {
        return new PacketTileStream(this).getPacket();
    }

    private void sendNetworkUpdateRipening() {
        Proxies.net.sendNetworkPacket(new PacketRipeningUpdate(this), this.worldObj);
    }

    @Override
    public void fromRipeningPacket(int newMaturity) {
        if (newMaturity == this.maturity) {
            return;
        }
        this.maturity = (short)newMaturity;
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public boolean hasFruit() {
        return true;
    }

    @Override
    public IFruitFamily getFruitFamily() {
        if (this.allele == null) {
            return null;
        }
        return this.allele.getProvider().getFamily();
    }

    @Override
    public Collection<ItemStack> pickFruit(ItemStack tool) {
        if (this.allele == null) {
            return new ArrayList<ItemStack>();
        }
        List<ItemStack> fruits = Arrays.asList(this.getDrop());
        this.maturity = 0;
        this.sendNetworkUpdateRipening();
        return fruits;
    }

    @Override
    public float getRipeness() {
        return (float)this.maturity / 2.0f;
    }

    @Override
    public void addRipeness(float add) {
        this.maturity = (short)((float)this.maturity + 2.0f * add);
        this.sendNetworkUpdateRipening();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeShort(this.maturity);
        data.writeShort(this.indices.length);
        for (int i : this.indices) {
            data.writeInt(i);
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.maturity = data.readShort();
        int indicesLength = data.readShort();
        this.indices = new int[indicesLength];
        for (int i = 0; i < indicesLength; ++i) {
            this.indices[i] = data.readInt();
        }
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }
}

