/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.Forestry;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.recipes.RecipeManagers;
import forestry.core.blocks.BlockBase;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.config.deprecated.Configuration;
import forestry.core.config.deprecated.Property;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemBlockForestry;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.tiles.MachineDefinition;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.Log;
import forestry.lepidopterology.ButterflySpawner;
import forestry.lepidopterology.GuiHandlerLepidopterology;
import forestry.lepidopterology.commands.CommandButterfly;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.genetics.AlleleEffect;
import forestry.lepidopterology.genetics.AlleleEffectNone;
import forestry.lepidopterology.genetics.ButterflyBranchDefinition;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.lepidopterology.genetics.ButterflyFactory;
import forestry.lepidopterology.genetics.ButterflyHelper;
import forestry.lepidopterology.genetics.MothDefinition;
import forestry.lepidopterology.items.ItemButterflyGE;
import forestry.lepidopterology.items.ItemFlutterlyzer;
import forestry.lepidopterology.proxy.ProxyLepidopterology;
import forestry.lepidopterology.recipes.MatingRecipe;
import forestry.lepidopterology.tiles.TileLepidopteristChest;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.io.File;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.RecipeSorter;

@Plugin(pluginID="Lepidopterology", name="Lepidopterology", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.lepidopterology.description")
public class PluginLepidopterology
extends ForestryPlugin {
    @SidedProxy(clientSide="forestry.lepidopterology.proxy.ProxyLepidopterologyClient", serverSide="forestry.lepidopterology.proxy.ProxyLepidopterology")
    public static ProxyLepidopterology proxy;
    private static final String CONFIG_CATEGORY = "lepidopterology";
    public static int spawnConstraint;
    public static int entityConstraint;
    private static boolean allowPollination;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        ButterflyManager.butterflyRoot = new ButterflyHelper();
        AlleleManager.alleleRegistry.registerSpeciesRoot(ButterflyManager.butterflyRoot);
        ButterflyManager.butterflyFactory = new ButterflyFactory();
    }

    @Override
    public void preInit() {
        ForestryBlock.lepidopterology.registerBlock((Block)new BlockBase(Material.iron, true), ItemBlockForestry.class, CONFIG_CATEGORY);
        ForestryBlock.lepidopterology.block().setCreativeTab(Tabs.tabLepidopterology);
        ButterflyBranchDefinition.createAlleles();
        AlleleEffect.butterflyNone = new AlleleEffectNone();
    }

    @Override
    public EnumSet<PluginManager.Module> getDependancies() {
        EnumSet<PluginManager.Module> deps = super.getDependancies();
        deps.add(PluginManager.Module.ARBORICULTURE);
        return deps;
    }

    @Override
    public void doInit() {
        String oldConfig = "lepidopterology.conf";
        String newConfig = "lepidopterology.cfg";
        File configFile = new File(Forestry.instance.getConfigFolder(), "lepidopterology.cfg");
        File oldConfigFile = new File(Forestry.instance.getConfigFolder(), "lepidopterology.conf");
        if (oldConfigFile.exists()) {
            PluginLepidopterology.loadOldConfig();
            String oldConfigRenamed = "lepidopterology.conf.old";
            File oldConfigFileRenamed = new File(Forestry.instance.getConfigFolder(), "lepidopterology.conf.old");
            if (oldConfigFile.renameTo(oldConfigFileRenamed)) {
                Log.info("Migrated lepidopterology settings to the new file 'lepidopterology.cfg' and renamed 'lepidopterology.conf' to 'lepidopterology.conf.old'.");
            }
        }
        PluginLepidopterology.loadNewConfig(configFile);
        PluginCore.rootCommand.addChildCommand(new CommandButterfly());
        EntityUtil.registerEntity(EntityButterfly.class, "butterflyGE", 0, 0, 0xFFFFFF, 50, 1, true);
        proxy.initializeRendering();
        MothDefinition.initMoths();
        ButterflyDefinition.initButterflies();
        BlockBase lepidopterology = (BlockBase)ForestryBlock.lepidopterology.block();
        MachineDefinition definitionChest = lepidopterology.addDefinition(new MachineDefinition(0, "forestry.LepiChest", TileLepidopteristChest.class, Proxies.render.getRenderChest("lepichest"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.lepidopterology.getItemStack(1, 0), " # ", "XYX", "XXX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), ForestryItem.butterflyGE.getItemStack(1, Short.MAX_VALUE), Character.valueOf('Y'), "chestWood")).setBoundingBox(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f));
        definitionChest.register();
        TreeManager.treeRoot.registerLeafTickHandler(new ButterflySpawner());
        RecipeSorter.register((String)"forestry:lepidopterologymating", MatingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shapeless");
    }

    private static void loadNewConfig(File configFile) {
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.0.0");
        spawnConstraint = config.getIntLocalized("butterfly.entities", "spawn.limit", spawnConstraint, 0, 500);
        entityConstraint = config.getIntLocalized("butterfly.entities", "maximum", entityConstraint, 0, 5000);
        allowPollination = config.getBooleanLocalized("butterfly.entities", "pollination", allowPollination);
        config.save();
    }

    private static void loadOldConfig() {
        Configuration config = new Configuration();
        Property property = config.get("entities.spawn.limit", CONFIG_CATEGORY, spawnConstraint);
        property.comment = "determines the global butterfly entity count above which natural spawning of butterflies ceases.";
        spawnConstraint = Integer.parseInt(property.value);
        property = config.get("entities.maximum.allowed", CONFIG_CATEGORY, entityConstraint);
        property.comment = "determines the global butterfly entity count above which butterflies will stay in item form and will not take flight anymore.";
        entityConstraint = Integer.parseInt(property.value);
        property = config.get("entities.pollination.allowed", CONFIG_CATEGORY, allowPollination);
        property.comment = "determines whether butterflies can pollinate leaves.";
        allowPollination = Boolean.parseBoolean(property.value);
    }

    @Override
    protected void registerItems() {
        ForestryItem.flutterlyzer.registerItem(new ItemFlutterlyzer(), "flutterlyzer");
        ForestryItem.butterflyGE.registerItem(new ItemButterflyGE(EnumFlutterType.BUTTERFLY), "butterflyGE");
        ForestryItem.serumGE.registerItem(new ItemButterflyGE(EnumFlutterType.SERUM), "serumGE");
        ForestryItem.caterpillarGE.registerItem(new ItemButterflyGE(EnumFlutterType.CATERPILLAR), "caterpillarGE");
    }

    @Override
    protected void registerRecipes() {
        CraftingManager.getInstance().getRecipeList().add(new MatingRecipe());
        RecipeManagers.carpenterManager.addRecipe(100, Fluids.WATER.getFluid(2000), null, ForestryItem.flutterlyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), "paneGlass", Character.valueOf('X'), "ingotBronze", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerLepidopterology();
    }

    public static boolean isPollinationAllowed() {
        return allowPollination;
    }

    static {
        spawnConstraint = 100;
        entityConstraint = 1000;
        allowPollination = true;
    }
}

