/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IFabricatorManager;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.FabricatorRecipe;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorRecipeManager
implements IFabricatorManager {
    private static final Set<IFabricatorRecipe> recipes = new HashSet<IFabricatorRecipe>();

    @Override
    public void addRecipe(ItemStack plan, FluidStack molten, ItemStack result, Object[] pattern) {
        FabricatorRecipe recipe = new FabricatorRecipe(plan, molten, ShapedRecipeCustom.createShapedRecipe(result, pattern));
        this.addRecipe(recipe);
    }

    @Override
    public void addSmelting(ItemStack resource, FluidStack molten, int meltingPoint) {
        RecipeManagers.fabricatorSmeltingManager.addSmelting(resource, molten, meltingPoint);
    }

    public static IFabricatorRecipe findMatchingRecipe(ItemStack plan, FluidStack liquid, ItemStack[] resources) {
        ItemStack[][] gridResources = new ItemStack[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                gridResources[j][i] = resources[i * 3 + j];
            }
        }
        for (IFabricatorRecipe recipe : recipes) {
            if (!recipe.matches(plan, gridResources) || liquid != null && !liquid.containsFluid(recipe.getLiquid())) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isPlan(ItemStack plan) {
        for (IFabricatorRecipe recipe : recipes) {
            if (!ItemStackUtil.isIdenticalItem(recipe.getPlan(), plan)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addRecipe(IFabricatorRecipe recipe) {
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(IFabricatorRecipe recipe) {
        return recipes.remove(recipe);
    }

    @Override
    public Set<IFabricatorRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }

    @Override
    public Map<Object[], Object[]> getRecipes() {
        HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
        for (IFabricatorRecipe recipe : recipes) {
            recipeList.put(recipe.getIngredients(), new Object[]{recipe.getRecipeOutput()});
        }
        return recipeList;
    }
}

