/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.core.multiblock.IMultiblockPart;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.multiblock.MultiblockWorldRegistry;
import forestry.core.utils.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.World;

public class MultiblockRegistry {
    private static final Map<World, MultiblockWorldRegistry> registries = new HashMap<World, MultiblockWorldRegistry>();

    public static void tickStart(World world) {
        if (registries.containsKey(world)) {
            MultiblockWorldRegistry registry = registries.get(world);
            registry.processMultiblockChanges();
            registry.tickStart();
        }
    }

    public static void onChunkLoaded(World world, int chunkX, int chunkZ) {
        if (registries.containsKey(world)) {
            registries.get(world).onChunkLoaded(chunkX, chunkZ);
        }
    }

    public static void onPartAdded(World world, IMultiblockPart part) {
        MultiblockWorldRegistry registry = MultiblockRegistry.getOrCreateRegistry(world);
        registry.onPartAdded(part);
    }

    public static void onPartRemovedFromWorld(World world, IMultiblockPart part) {
        if (registries.containsKey(world)) {
            registries.get(world).onPartRemovedFromWorld(part);
        }
    }

    public static void onWorldUnloaded(World world) {
        if (registries.containsKey(world)) {
            registries.get(world).onWorldUnloaded();
            registries.remove(world);
        }
    }

    public static void addDirtyController(World world, MultiblockControllerBase controller) {
        if (!registries.containsKey(world)) {
            throw new IllegalArgumentException("Adding a dirty controller to a world that has no registered controllers!");
        }
        registries.get(world).addDirtyController(controller);
    }

    public static void addDeadController(World world, MultiblockControllerBase controller) {
        if (registries.containsKey(world)) {
            registries.get(world).addDeadController(controller);
        } else {
            Log.warning("Controller %d in world %s marked as dead, but that world is not tracked! Controller is being ignored.", controller.hashCode(), world);
        }
    }

    public static Set<MultiblockControllerBase> getControllersFromWorld(World world) {
        if (registries.containsKey(world)) {
            return registries.get(world).getControllers();
        }
        return null;
    }

    private static MultiblockWorldRegistry getOrCreateRegistry(World world) {
        if (registries.containsKey(world)) {
            return registries.get(world);
        }
        MultiblockWorldRegistry newRegistry = new MultiblockWorldRegistry(world);
        registries.put(world, newRegistry);
        return newRegistry;
    }
}

