/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.api.core.IToolPipette;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.farming.gui.ContainerFarm;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class TankWidget
extends Widget {
    private int overlayTexX = 176;
    private int overlayTexY = 0;
    private int slot = 0;

    public TankWidget(WidgetManager manager, int xPos, int yPos, int slot) {
        super(manager, xPos, yPos);
        this.slot = slot;
        this.height = 58;
    }

    public TankWidget setOverlayOrigin(int x, int y) {
        this.overlayTexX = x;
        this.overlayTexY = y;
        return this;
    }

    public IFluidTank getTank() {
        Container container = this.manager.gui.inventorySlots;
        if (container instanceof IContainerLiquidTanks) {
            return ((IContainerLiquidTanks)container).getTank(this.slot);
        }
        if (container instanceof ContainerFarm) {
            return ((ContainerFarm)container).getTank(this.slot);
        }
        return null;
    }

    @Override
    public void draw(int startX, int startY) {
        int x;
        IFluidTank tank = this.getTank();
        if (tank == null) {
            return;
        }
        FluidStack contents = tank.getFluid();
        if (contents == null || contents.amount <= 0 || contents.getFluid() == null) {
            return;
        }
        IIcon liquidIcon = contents.getFluid().getIcon(contents);
        if (liquidIcon == null) {
            return;
        }
        int squaled = contents.amount * this.height / this.getTank().getCapacity();
        Proxies.render.bindTexture(SpriteSheet.BLOCKS);
        int start = 0;
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        do {
            if (squaled > 16) {
                x = 16;
                squaled -= 16;
            } else {
                x = squaled;
                squaled = 0;
            }
            this.manager.gui.drawTexturedModelRectFromIcon(startX + this.xPos, startY + this.yPos + this.height - x - start, liquidIcon, 16, 16 - (16 - x));
            start += 16;
        } while (x != 0 && squaled != 0);
        Proxies.render.bindTexture(this.manager.gui.textureFile);
        this.manager.gui.drawTexturedModalRect(startX + this.xPos, startY + this.yPos, this.overlayTexX, this.overlayTexY, 16, 60);
        GL11.glPopAttrib();
    }

    @Override
    public ToolTip getToolTip() {
        IFluidTank tank = this.getTank();
        if (!(tank instanceof StandardTank)) {
            return null;
        }
        return ((StandardTank)tank).getToolTip();
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        ItemStack itemstack = this.manager.minecraft.thePlayer.inventory.getItemStack();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.getItem();
        if (held instanceof IToolPipette && this.manager.gui.inventorySlots instanceof IContainerLiquidTanks) {
            ((IContainerLiquidTanks)this.manager.gui.inventorySlots).handlePipetteClickClient(this.slot, (EntityPlayer)this.manager.minecraft.thePlayer);
        }
    }
}

