/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IStillRecipe;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.recipes.StillRecipeManager;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class TileStill
extends TilePowered
implements ISidedInventory,
ILiquidTankTile {
    public static final short SLOT_PRODUCT = 0;
    public static final short SLOT_RESOURCE = 1;
    public static final short SLOT_CAN = 2;
    private final FilteredTank resourceTank;
    private final FilteredTank productTank;
    private final TankManager tankManager;
    private IStillRecipe currentRecipe;
    private FluidStack bufferedLiquid;
    private int distillationTime = 0;
    private int distillationTotalTime = 0;

    public TileStill() {
        super(1100, 8000, 200);
        this.setInternalInventory(new StillInventoryAdapter(this));
        this.setHints(Config.hints.get("still"));
        this.resourceTank = new FilteredTank(10000, StillRecipeManager.recipeFluidInputs);
        this.resourceTank.tankMode = StandardTank.TankMode.INPUT;
        this.productTank = new FilteredTank(10000, StillRecipeManager.recipeFluidOutputs);
        this.productTank.tankMode = StandardTank.TankMode.OUTPUT;
        this.tankManager = new TankManager(this.resourceTank, this.productTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.StillGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("DistillationTime", this.distillationTime);
        nbttagcompound.setInteger("DistillationTotalTime", this.distillationTotalTime);
        this.tankManager.writeTanksToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.distillationTime = nbttagcompound.getInteger("DistillationTime");
        this.distillationTotalTime = nbttagcompound.getInteger("DistillationTotalTime");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        this.checkRecipe();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readPacketData(data);
    }

    @Override
    public void updateServerSide() {
        FluidStack fluidStack;
        super.updateServerSide();
        if (!this.updateOnInterval(20)) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(2) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)inventory, 2);
        }
        if (inventory.getStackInSlot(1) != null && (fluidStack = this.productTank.getFluid()) != null) {
            FluidHelper.fillContainers(this.tankManager, (IInventory)inventory, 1, 0, fluidStack.getFluid());
        }
        this.checkRecipe();
    }

    @Override
    public boolean workCycle() {
        IErrorLogic errorLogic = this.getErrorLogic();
        this.checkRecipe();
        if (this.distillationTime > 0 && !errorLogic.hasErrors()) {
            this.distillationTime -= this.currentRecipe.getInput().amount;
            this.productTank.fill(this.currentRecipe.getOutput(), true);
            return true;
        }
        if (this.currentRecipe != null) {
            int resourceRequired = this.currentRecipe.getCyclesPerUnit() * this.currentRecipe.getInput().amount;
            boolean canFill = this.productTank.fill(this.currentRecipe.getOutput(), false) == this.currentRecipe.getOutput().amount;
            errorLogic.setCondition(!canFill, EnumErrorCode.NOSPACETANK);
            boolean hasResource = this.resourceTank.getFluidAmount() >= resourceRequired;
            errorLogic.setCondition(!hasResource, EnumErrorCode.NORESOURCE);
            if (!errorLogic.hasErrors()) {
                this.distillationTime = this.distillationTotalTime = resourceRequired;
                this.resourceTank.drain(resourceRequired, true);
                this.bufferedLiquid = new FluidStack(this.currentRecipe.getInput(), resourceRequired);
                return true;
            }
        }
        this.bufferedLiquid = null;
        return false;
    }

    private void checkRecipe() {
        IStillRecipe matchingRecipe = StillRecipeManager.findMatchingRecipe(this.resourceTank.getFluid());
        if (matchingRecipe == null && this.bufferedLiquid != null && this.distillationTime > 0) {
            matchingRecipe = StillRecipeManager.findMatchingRecipe(new FluidStack(this.bufferedLiquid, this.distillationTime));
        }
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
        }
        this.getErrorLogic().setCondition(this.currentRecipe == null, EnumErrorCode.NORECIPE);
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        return (this.distillationTime > 0 || this.resourceTank.getFluidAmount() >= this.currentRecipe.getCyclesPerUnit() * this.currentRecipe.getInput().amount) && this.productTank.getFluidAmount() <= this.productTank.getCapacity() - this.currentRecipe.getOutput().amount;
    }

    public int getDistillationProgressScaled(int i) {
        if (this.distillationTotalTime == 0) {
            return i;
        }
        return this.distillationTime * i / this.distillationTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public int getProductScaled(int i) {
        return this.productTank.getFluidAmount() * i / 10000;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank, this.getResourceScaled(100));
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank, this.getProductScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.distillationTime = j;
                break;
            }
            case 1: {
                this.distillationTotalTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.sendProgressBarUpdate(container, i, this.distillationTime);
        iCrafting.sendProgressBarUpdate(container, i + 1, this.distillationTotalTime);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.tankManager.drain(from, quantityMax, doEmpty);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class StillInventoryAdapter
    extends TileInventoryAdapter<TileStill> {
        public StillInventoryAdapter(TileStill still) {
            super(still, 3, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 1) {
                return FluidHelper.isEmptyContainer(itemStack);
            }
            if (slotIndex == 2) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((TileStill)this.tile).resourceTank.accepts(fluid);
            }
            return false;
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 0;
        }
    }
}

