/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.EnumWoodType;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketTileStream;
import forestry.core.utils.ItemStackUtil;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileWood
extends TileEntity
implements IStreamable {
    private EnumWoodType woodType = EnumWoodType.LARCH;

    public void setWoodType(EnumWoodType woodType) {
        this.woodType = woodType;
        this.markDirty();
    }

    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    public boolean canUpdate() {
        return false;
    }

    public Packet getDescriptionPacket() {
        return new PacketTileStream(this).getPacket();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.woodType.ordinal());
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        int ordinal = data.readVarInt();
        this.woodType = EnumWoodType.VALUES[ordinal];
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.woodType != null) {
            nbt.setInteger("WT", this.woodType.ordinal());
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.hasKey("WT")) {
            int ordinal = nbt.getInteger("WT");
            this.woodType = EnumWoodType.VALUES[ordinal];
        }
    }

    public static <T extends Block> boolean blockRemovedByPlayer(T block, World world, EntityPlayer player, int x, int y, int z) {
        TileEntity tile;
        int meta = world.getBlockMetadata(x, y, z);
        if (!world.isRemote && block.canHarvestBlock(player, meta) && !player.capabilities.isCreativeMode && (tile = world.getTileEntity(x, y, z)) instanceof TileWood) {
            TileWood wood = (TileWood)tile;
            ItemStack stack = new ItemStack(block);
            NBTTagCompound compound = new NBTTagCompound();
            wood.getWoodType().saveToCompound(compound);
            stack.setTagCompound(compound);
            ItemStackUtil.dropItemStackAsEntity(stack, world, x, y, z);
        }
        return world.setBlockToAir(x, y, z);
    }
}

