/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.AIButterflyBase;
import forestry.lepidopterology.entities.EntityButterfly;
import net.minecraft.util.ChunkCoordinates;

public abstract class AIButterflyMovement
extends AIButterflyBase {
    protected ChunkCoordinates flightTarget;

    protected AIButterflyMovement(EntityButterfly entity) {
        super(entity);
    }

    public boolean continueExecuting() {
        if (this.entity.getState() != EntityButterfly.EnumButterflyState.FLYING) {
            return false;
        }
        if (this.flightTarget == null) {
            return false;
        }
        if (this.entity.getDestination() == null || !this.entity.getDestination().equals((Object)this.flightTarget)) {
            return false;
        }
        if (this.entity.getDestination().getDistanceSquared((int)this.entity.posX, (int)this.entity.posY, (int)this.entity.posZ) > 2.0f) {
            return true;
        }
        this.entity.setDestination(null);
        return false;
    }

    public void updateTask() {
        if (this.entity.isInWater()) {
            this.flightTarget = this.getRandomDestinationUpwards();
        } else if (this.entity.isCollided) {
            this.flightTarget = this.entity.getRNG().nextBoolean() ? this.getRandomDestination() : null;
        } else if (this.entity.worldObj.rand.nextInt(300) == 0) {
            this.flightTarget = this.getRandomDestination();
        }
        this.entity.setDestination(this.flightTarget);
        this.entity.changeExhaustion(1);
    }

    public void startExecuting() {
    }

    public void resetTask() {
        this.flightTarget = null;
    }
}

