/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.items.ICraftingPlan;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.tiles.ICrafter;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.SlotUtil;
import forestry.factory.recipes.FabricatorRecipeManager;
import forestry.factory.recipes.FabricatorSmeltingRecipe;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileFabricator
extends TilePowered
implements ICrafter,
ILiquidTankTile,
ISidedInventory {
    private static final int MAX_HEAT = 5000;
    public static final short SLOT_METAL = 0;
    public static final short SLOT_PLAN = 1;
    public static final short SLOT_RESULT = 2;
    public static final short SLOT_CRAFTING_LEGACY_1 = 3;
    public static final short SLOT_CRAFTING_LEGACY_COUNT = 9;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    public static final short SLOT_COUNT = 30;
    public static final short SLOT_CRAFTING_1 = 0;
    public static final short SLOT_CRAFTING_COUNT = 9;
    private final TileInventoryAdapter craftingInventory = new TileInventoryAdapter<TileFabricator>(this, 9, "CraftItems");
    private final TankManager tankManager;
    private final FilteredTank moltenTank;
    private int heat = 0;
    private int guiMeltingPoint = 0;

    public TileFabricator() {
        super(1100, 3300, 200);
        this.setInternalInventory(new FabricatorInventoryAdapter(this));
        this.moltenTank = new FilteredTank(2000, Fluids.GLASS.getFluid());
        this.moltenTank.tankMode = StandardTank.TankMode.INTERNAL;
        this.tankManager = new TankManager(this.moltenTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.FabricatorGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("Heat", this.heat);
        this.tankManager.writeTanksToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.heat = nbttagcompound.getInteger("Heat");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int slot = 3; slot < 12; ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack == null) continue;
            inventory.setInventorySlotContents(slot, null);
            int newSlot = slot - 3;
            this.craftingInventory.setInventorySlotContents(newSlot, stack);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readPacketData(data);
    }

    @Override
    public void updateServerSide() {
        FabricatorSmeltingRecipe smelt;
        super.updateServerSide();
        if (!this.moltenTank.isFull()) {
            this.trySmelting();
        }
        if (!this.moltenTank.isEmpty() && (smelt = FabricatorRecipeManager.findMatchingSmelting(this.moltenTank.getFluid())) != null && this.heat < smelt.getMeltingPoint()) {
            this.moltenTank.drain(5, true);
        }
        this.dissipateHeat();
    }

    private void trySmelting() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack smeltResource = inventory.getStackInSlot(0);
        if (smeltResource == null) {
            return;
        }
        FabricatorSmeltingRecipe smelt = FabricatorRecipeManager.findMatchingSmelting(smeltResource);
        if (smelt == null || smelt.getMeltingPoint() > this.heat) {
            return;
        }
        FluidStack smeltFluid = smelt.getProduct();
        if (this.moltenTank.fill(smeltFluid, false) == smeltFluid.amount) {
            this.decrStackSize(0, 1);
            this.moltenTank.fill(smeltFluid, true);
        }
    }

    @Override
    public boolean workCycle() {
        this.craftResult(null);
        return this.addHeat(100);
    }

    private boolean addHeat(int addition) {
        if (this.heat >= 5000) {
            return false;
        }
        this.heat += addition;
        if (this.heat > 5000) {
            this.heat = 5000;
        }
        return true;
    }

    private void dissipateHeat() {
        if (this.heat > 2500) {
            this.heat -= 2;
        } else if (this.heat > 0) {
            --this.heat;
        }
    }

    private IFabricatorRecipe getRecipe() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack plan = inventory.getStackInSlot(1);
        ItemStack[] crafting = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        return FabricatorRecipeManager.findMatchingRecipe(plan, this.moltenTank.getFluid(), crafting);
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        return true;
    }

    @Override
    public ItemStack getResult() {
        IFabricatorRecipe myRecipe = this.getRecipe();
        if (myRecipe == null) {
            return null;
        }
        return myRecipe.getCraftingResult((IInventory)this.craftingInventory);
    }

    @Override
    public ItemStack takenFromSlot(int slotIndex, EntityPlayer player) {
        if (slotIndex != 2) {
            return null;
        }
        return this.getInternalInventory().decrStackSize(2, 1);
    }

    private void craftResult(EntityPlayer player) {
        Item planItem;
        IFabricatorRecipe myRecipe = this.getRecipe();
        if (myRecipe == null) {
            return;
        }
        ItemStack result = this.getResult();
        if (result == null) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(2) != null) {
            return;
        }
        FluidStack liquid = myRecipe.getLiquid();
        ItemStack[] crafting = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        if (!this.removeFromInventory(crafting, player, false)) {
            return;
        }
        FluidStack canDrain = this.moltenTank.drain(liquid.amount, false);
        if (canDrain == null || !canDrain.isFluidStackIdentical(liquid)) {
            return;
        }
        this.removeFromInventory(crafting, player, true);
        this.moltenTank.drain(liquid.amount, true);
        if (inventory.getStackInSlot(1) != null && (planItem = inventory.getStackInSlot(1).getItem()) instanceof ICraftingPlan) {
            inventory.setInventorySlotContents(1, ((ICraftingPlan)planItem).planUsed(inventory.getStackInSlot(1), result));
        }
        inventory.setInventorySlotContents(2, result);
    }

    private boolean removeFromInventory(ItemStack[] set, EntityPlayer player, boolean doRemove) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (doRemove) {
            return InventoryUtil.removeSets((IInventory)inventory, 1, set, 12, 18, player, true, true);
        }
        ItemStack[] stock = InventoryUtil.getStacks((IInventory)inventory, 12, 18);
        return ItemStackUtil.containsSets(set, stock) >= 1;
    }

    @Override
    public boolean hasWork() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack itemToMelt = inventory.getStackInSlot(0);
        FabricatorSmeltingRecipe smelting = FabricatorRecipeManager.findMatchingSmelting(itemToMelt);
        if (smelting != null && this.moltenTank.fill(smelting.getProduct(), false) > 0) {
            return true;
        }
        ItemStack plan = inventory.getStackInSlot(1);
        ItemStack[] resources = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        return FabricatorRecipeManager.findMatchingRecipe(plan, this.moltenTank.getFluid(), resources) != null;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    private int getMeltingPoint() {
        FabricatorSmeltingRecipe smelt;
        if (this.moltenTank.getFluidAmount() > 0) {
            FabricatorSmeltingRecipe smelt2 = FabricatorRecipeManager.findMatchingSmelting(this.moltenTank.getFluid());
            if (smelt2 != null) {
                return smelt2.getMeltingPoint();
            }
        } else if (this.getStackInSlot(0) != null && (smelt = FabricatorRecipeManager.findMatchingSmelting(this.getStackInSlot(0))) != null) {
            return smelt.getMeltingPoint();
        }
        return 0;
    }

    public int getMeltingPointScaled(int i) {
        if (this.guiMeltingPoint > 0) {
            return this.guiMeltingPoint * i / 5000;
        }
        int meltingPoint = this.getMeltingPoint();
        if (meltingPoint <= 0) {
            return 0;
        }
        return meltingPoint * i / 5000;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        int messageId = this.tankManager.maxMessageId() + 1;
        if (i == messageId) {
            this.heat = j;
        } else if (i == messageId + 1) {
            this.guiMeltingPoint = j;
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int messageId = this.tankManager.maxMessageId() + 1;
        iCrafting.sendProgressBarUpdate(container, messageId, this.heat);
        iCrafting.sendProgressBarUpdate(container, messageId + 1, this.getMeltingPoint());
    }

    public InventoryAdapter getCraftingInventory() {
        return this.craftingInventory;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class FabricatorInventoryAdapter
    extends TileInventoryAdapter<TileFabricator> {
        public FabricatorInventoryAdapter(TileFabricator fabricator) {
            super(fabricator, 30, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return FabricatorRecipeManager.findMatchingSmelting(itemStack) != null;
            }
            if (slotIndex == 1) {
                return FabricatorRecipeManager.isPlan(itemStack);
            }
            if (SlotUtil.isSlotInRange(slotIndex, 12, 18)) {
                if (FabricatorRecipeManager.isPlan(itemStack)) {
                    return false;
                }
                if (FabricatorRecipeManager.findMatchingSmelting(itemStack) != null) {
                    return false;
                }
            }
            return SlotUtil.isSlotInRange(slotIndex, 12, 18);
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack stack, int side) {
            return slotIndex == 2;
        }
    }
}

