/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import forestry.apiculture.blocks.BlockCandle;
import forestry.apiculture.tiles.TileCandle;
import forestry.core.ForestryClient;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class RenderCandleBlock
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (block.getRenderType() == ForestryClient.candleRenderId) {
            RenderCandleBlock.renderBlockCandle(world, x, y, z, (BlockCandle)block);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return ForestryClient.candleRenderId;
    }

    private static boolean renderBlockCandle(IBlockAccess world, int x, int y, int z, BlockCandle block) {
        int meta = world.getBlockMetadata(x, y, z);
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (!(tileEntity instanceof TileCandle)) {
            return false;
        }
        TileCandle tileCandle = (TileCandle)tileEntity;
        boolean isLit = tileCandle.isLit();
        IIcon iconA = block.getTextureFromPassAndLit(0, isLit);
        IIcon iconB = block.getTextureFromPassAndLit(1, isLit);
        int colour = tileCandle.getColour();
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(world.getLightBrightnessForSkyBlocks(x, y, z, block.getLightValue(world, x, y, z)));
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        double d0 = 0.4f;
        double d1 = 0.5 - d0;
        double d2 = 0.2f;
        if (meta == 1) {
            RenderCandleBlock.renderCandleAtAngle(iconA, (double)x - d1, (double)y + d2, z, -d0, 0.0, 0xFFFFFF);
            RenderCandleBlock.renderCandleAtAngle(iconB, (double)x - d1, (double)y + d2, z, -d0, 0.0, colour);
        } else if (meta == 2) {
            RenderCandleBlock.renderCandleAtAngle(iconA, (double)x + d1, (double)y + d2, z, d0, 0.0, 0xFFFFFF);
            RenderCandleBlock.renderCandleAtAngle(iconB, (double)x + d1, (double)y + d2, z, d0, 0.0, colour);
        } else if (meta == 3) {
            RenderCandleBlock.renderCandleAtAngle(iconA, x, (double)y + d2, (double)z - d1, 0.0, -d0, 0xFFFFFF);
            RenderCandleBlock.renderCandleAtAngle(iconB, x, (double)y + d2, (double)z - d1, 0.0, -d0, colour);
        } else if (meta == 4) {
            RenderCandleBlock.renderCandleAtAngle(iconA, x, (double)y + d2, (double)z + d1, 0.0, d0, 0xFFFFFF);
            RenderCandleBlock.renderCandleAtAngle(iconB, x, (double)y + d2, (double)z + d1, 0.0, d0, colour);
        } else {
            RenderCandleBlock.renderCandleAtAngle(iconA, x, y, z, 0.0, 0.0, 0xFFFFFF);
            RenderCandleBlock.renderCandleAtAngle(iconB, x, y, z, 0.0, 0.0, colour);
        }
        return true;
    }

    private static void renderCandleAtAngle(IIcon icon, double x, double y, double z, double par8, double par10, int colour) {
        Tessellator tessellator = Tessellator.instance;
        double minU = icon.getMinU();
        double minV = icon.getMinV();
        double maxU = icon.getMaxU();
        double maxV = icon.getMaxV();
        double textureLightTopU = icon.getInterpolatedU(7.0);
        double d10 = icon.getInterpolatedV(6.0);
        double textureLightBottomU = icon.getInterpolatedU(9.0);
        double d12 = icon.getInterpolatedV(8.0);
        double d14 = icon.getInterpolatedV(13.0);
        double d16 = icon.getInterpolatedV(15.0);
        double d17 = (x += 0.5) - 0.5;
        double d18 = x + 0.5;
        double d19 = (z += 0.5) - 0.5;
        double d20 = z + 0.5;
        double d21 = 0.0625;
        double d22 = 0.625;
        tessellator.setColorOpaque_I(colour);
        tessellator.addVertexWithUV(x + par8 * (1.0 - d22) - d21, y + d22, z + par10 * (1.0 - d22) - d21, textureLightTopU, d10);
        tessellator.addVertexWithUV(x + par8 * (1.0 - d22) - d21, y + d22, z + par10 * (1.0 - d22) + d21, textureLightTopU, d12);
        tessellator.addVertexWithUV(x + par8 * (1.0 - d22) + d21, y + d22, z + par10 * (1.0 - d22) + d21, textureLightBottomU, d12);
        tessellator.addVertexWithUV(x + par8 * (1.0 - d22) + d21, y + d22, z + par10 * (1.0 - d22) - d21, textureLightBottomU, d10);
        tessellator.addVertexWithUV(x - d21, y + 1.0, d19, minU, minV);
        tessellator.addVertexWithUV(x - d21 + par8, y, d19 + par10, minU, maxV);
        tessellator.addVertexWithUV(x - d21 + par8, y, d20 + par10, maxU, maxV);
        tessellator.addVertexWithUV(x - d21, y + 1.0, d20, maxU, minV);
        tessellator.addVertexWithUV(x + d21, y + 1.0, d20, minU, minV);
        tessellator.addVertexWithUV(x + par8 + d21, y, d20 + par10, minU, maxV);
        tessellator.addVertexWithUV(x + par8 + d21, y, d19 + par10, maxU, maxV);
        tessellator.addVertexWithUV(x + d21, y + 1.0, d19, maxU, minV);
        tessellator.addVertexWithUV(d18, y + 1.0, z - d21, minU, minV);
        tessellator.addVertexWithUV(d18 + par8, y, z - d21 + par10, minU, maxV);
        tessellator.addVertexWithUV(d17 + par8, y, z - d21 + par10, maxU, maxV);
        tessellator.addVertexWithUV(d17, y + 1.0, z - d21, maxU, minV);
        tessellator.addVertexWithUV(d17, y + 1.0, z + d21, minU, minV);
        tessellator.addVertexWithUV(d17 + par8, y, z + d21 + par10, minU, maxV);
        tessellator.addVertexWithUV(d18 + par8, y, z + d21 + par10, maxU, maxV);
        tessellator.addVertexWithUV(d18, y + 1.0, z + d21, maxU, minV);
        tessellator.addVertexWithUV(x + d21 + par8, y, z - d21 + par10, textureLightBottomU, d14);
        tessellator.addVertexWithUV(x + d21 + par8, y, z + d21 + par10, textureLightBottomU, d16);
        tessellator.addVertexWithUV(x - d21 + par8, y, z + d21 + par10, textureLightTopU, d16);
        tessellator.addVertexWithUV(x - d21 + par8, y, z - d21 + par10, textureLightTopU, d14);
    }
}

