/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.Vec3;

public class AIAvoidPlayers
extends EntityAIBase {
    private final EntityCreature mob;
    private final float farSpeed;
    private final float nearSpeed;
    private final float minDistance;
    private PathEntity pathing;
    private final PathNavigate pathNavigator;
    private EntityPlayer player;

    public AIAvoidPlayers(EntityCreature mob, float minDistance, float farSpeed, float nearSpeed) {
        this.mob = mob;
        this.minDistance = minDistance;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        this.pathNavigator = mob.getNavigator();
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        this.player = this.mob.worldObj.getClosestPlayerToEntity((Entity)this.mob, (double)this.minDistance);
        if (this.player == null) {
            return false;
        }
        if (!this.mob.getEntitySenses().canSee((Entity)this.player)) {
            return false;
        }
        Vec3 randomTarget = RandomPositionGenerator.findRandomTargetBlockAwayFrom((EntityCreature)this.mob, (int)16, (int)7, (Vec3)Vec3.createVectorHelper((double)this.player.posX, (double)this.player.posY, (double)this.player.posZ));
        if (randomTarget == null) {
            return false;
        }
        if (this.player.getDistanceSq(randomTarget.xCoord, randomTarget.yCoord, randomTarget.zCoord) < this.player.getDistanceSqToEntity((Entity)this.mob)) {
            return false;
        }
        this.pathing = this.pathNavigator.getPathToXYZ(randomTarget.xCoord, randomTarget.yCoord, randomTarget.zCoord);
        return this.pathing != null && this.pathing.isDestinationSame(randomTarget);
    }

    public boolean continueExecuting() {
        return !this.pathNavigator.noPath();
    }

    public void startExecuting() {
        this.pathNavigator.setPath(this.pathing, (double)this.farSpeed);
    }

    public void resetTask() {
        this.player = null;
    }

    public void updateTask() {
        if (this.mob.getDistanceSqToEntity((Entity)this.player) < 49.0) {
            this.mob.getNavigator().setSpeed((double)this.nearSpeed);
        } else {
            this.mob.getNavigator().setSpeed((double)this.farSpeed);
        }
    }
}

