/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.AIButterflyMovement;
import forestry.lepidopterology.entities.EntityButterfly;

public class AIButterflyRise
extends AIButterflyMovement {
    public AIButterflyRise(EntityButterfly entity) {
        super(entity);
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        if (this.entity.getDestination() != null) {
            return false;
        }
        if (!this.entity.isCollidedHorizontally && this.entity.getRNG().nextInt(64) != 0) {
            return false;
        }
        this.flightTarget = this.getRandomDestinationUpwards();
        if (this.flightTarget == null) {
            if (this.entity.getState().doesMovement) {
                this.entity.setState(EntityButterfly.EnumButterflyState.HOVER);
            }
            return false;
        }
        this.entity.setDestination(this.flightTarget);
        this.entity.setState(EntityButterfly.EnumButterflyState.RISING);
        return true;
    }

    @Override
    public boolean continueExecuting() {
        if (this.entity.getState() != EntityButterfly.EnumButterflyState.RISING) {
            return false;
        }
        if (this.flightTarget == null) {
            return false;
        }
        if (this.entity.getDestination() == null || !this.entity.getDestination().equals((Object)this.flightTarget)) {
            return false;
        }
        if (this.entity.getDestination().getDistanceSquared((int)this.entity.posX, (int)this.entity.posY, (int)this.entity.posZ) > 2.0f) {
            return true;
        }
        this.entity.setDestination(null);
        return false;
    }

    @Override
    public void updateTask() {
        if (this.entity.isInWater()) {
            this.flightTarget = this.getRandomDestinationUpwards();
        } else if (this.entity.isCollidedVertically && this.entity.getRNG().nextInt(62) == 0) {
            this.flightTarget = null;
        }
        this.entity.setDestination(this.flightTarget);
        this.entity.changeExhaustion(1);
    }
}

