/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.apiculture.flowers.FlowerProvider;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.genetics.alleles.AlleleInteger;
import forestry.core.genetics.alleles.AlleleTolerance;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleHelper;
import forestry.core.genetics.alleles.IAlleleValue;
import forestry.core.utils.vect.IVect;
import forestry.plugins.PluginManager;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AlleleHelper
implements IAlleleHelper {
    private static final String modId = "forestry";
    private final Map<Class, Map<?, ? extends IAllele>> alleleMaps = new HashMap();

    public void init() {
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            this.createAlleles(EnumAllele.Fertility.class);
            this.createAlleles(EnumAllele.Flowering.class);
        }
        if (PluginManager.Module.APICULTURE.isEnabled() || PluginManager.Module.ARBORICULTURE.isEnabled()) {
            this.createAlleles(EnumAllele.Territory.class);
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.territoryDefault", this.get(EnumAllele.Territory.AVERAGE));
        }
        if (PluginManager.Module.APICULTURE.isEnabled() || PluginManager.Module.LEPIDOPTEROLOGY.isEnabled()) {
            this.createAlleles(EnumAllele.Speed.class);
            this.createAlleles(EnumAllele.Lifespan.class);
            this.createAlleles(EnumAllele.Tolerance.class);
            this.createAlleles(EnumAllele.Flowers.class);
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.speedNorm", this.get(EnumAllele.Speed.NORMAL));
        }
        if (PluginManager.Module.ARBORICULTURE.isEnabled()) {
            this.createAlleles(EnumAllele.Height.class);
            this.createAlleles(EnumAllele.Saplings.class);
            this.createAlleles(EnumAllele.Yield.class);
            this.createAlleles(EnumAllele.Fireproof.class);
            this.createAlleles(EnumAllele.Maturation.class);
            this.createAlleles(EnumAllele.Sappiness.class);
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.heightMax10", this.get(EnumAllele.Height.AVERAGE));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.saplingsDefault", this.get(EnumAllele.Saplings.AVERAGE));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.saplingsDouble", this.get(EnumAllele.Saplings.HIGH));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.saplingsTriple", this.get(EnumAllele.Saplings.HIGHER));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.yieldDefault", this.get(EnumAllele.Yield.AVERAGE));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturitySlowest", this.get(EnumAllele.Maturation.SLOWEST));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturitySlower", this.get(EnumAllele.Maturation.SLOWER));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturitySlow", this.get(EnumAllele.Maturation.SLOW));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturityAverage", this.get(EnumAllele.Maturation.AVERAGE));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturityFast", this.get(EnumAllele.Maturation.FAST));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturityFaster", this.get(EnumAllele.Maturation.FASTER));
            AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("forestry.maturityFastest", this.get(EnumAllele.Maturation.FASTEST));
        }
        if (PluginManager.Module.LEPIDOPTEROLOGY.isEnabled()) {
            this.createAlleles(EnumAllele.Size.class);
        }
        HashMap<Integer, AlleleInteger> integers = new HashMap<Integer, AlleleInteger>();
        for (int i = 1; i <= 10; ++i) {
            AlleleInteger alleleInteger = new AlleleInteger(modId, "i", i + "d", i, true);
            integers.put(i, alleleInteger);
        }
        this.alleleMaps.put(Integer.class, integers);
        HashMap<Boolean, AlleleBoolean> booleans = new HashMap<Boolean, AlleleBoolean>();
        booleans.put(true, new AlleleBoolean(modId, "bool", true, false));
        booleans.put(false, new AlleleBoolean(modId, "bool", false, false));
        this.alleleMaps.put(Boolean.class, booleans);
    }

    private IAllele get(Object value) {
        Class<?> valueClass = value.getClass();
        Map<?, IAllele> map = this.alleleMaps.get(valueClass);
        if (map == null) {
            throw new IllegalArgumentException("There is no IAllele type for: " + valueClass + ' ' + value);
        }
        IAllele allele = map.get(value);
        if (allele == null) {
            throw new IllegalArgumentException("There is no IAllele for: " + valueClass + ' ' + value);
        }
        return allele;
    }

    @Override
    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, IAllele allele) {
        if (allele == null) {
            throw new NullPointerException("Allele must not be null");
        }
        if (!((IChromosomeType)((Object)chromosomeType)).getAlleleClass().isInstance(allele)) {
            throw new IllegalArgumentException("Allele is the wrong type. Expected: " + chromosomeType + " Got: " + allele);
        }
        alleles[chromosomeType.ordinal()] = allele;
    }

    @Override
    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, IAlleleValue value) {
        this.set(alleles, chromosomeType, this.get(value));
    }

    @Override
    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, boolean value) {
        this.set(alleles, chromosomeType, this.get(value));
    }

    @Override
    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, int value) {
        this.set(alleles, chromosomeType, this.get(value));
    }

    private <K extends Enum<K>, V> void createAlleles(Class<K> enumClass) {
        String category = enumClass.getSimpleName().toLowerCase(Locale.ENGLISH);
        EnumMap<Enum, IAllele> map = new EnumMap<Enum, IAllele>(enumClass);
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            IAllele allele = AlleleHelper.createAllele(category, (IAlleleValue)((Object)enumValue));
            map.put(enumValue, allele);
        }
        this.alleleMaps.put(enumClass, map);
    }

    private static <K extends IAlleleValue<V>, V> IAllele createAllele(String category, K enumValue) {
        V value = enumValue.getValue();
        boolean isDominant = enumValue.isDominant();
        String name = enumValue.toString().toLowerCase(Locale.ENGLISH);
        Class<?> valueClass = value.getClass();
        if (Float.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createFloat(modId, category, name, ((Float)value).floatValue(), isDominant);
        }
        if (Integer.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createInteger(modId, category, name, (Integer)value, isDominant);
        }
        if (IVect.class.isAssignableFrom(valueClass)) {
            IVect area = (IVect)value;
            return AlleleManager.alleleFactory.createArea(modId, category, name, area.getX(), area.getY(), area.getZ(), isDominant);
        }
        if (Boolean.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createBoolean(modId, category, (Boolean)value, isDominant);
        }
        if (EnumTolerance.class.isAssignableFrom(valueClass)) {
            return new AlleleTolerance(modId, category, name, (EnumTolerance)((Object)value), isDominant);
        }
        if (FlowerProvider.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createFlowers(modId, category, name, (FlowerProvider)value, isDominant);
        }
        throw new RuntimeException("could not create allele for category: " + category + " and value " + valueClass);
    }
}

