/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.CreativeTabForestry;
import forestry.core.fluids.BlockForestryFluid;
import forestry.core.fluids.FluidHelper;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class ItemLiquidContainer
extends Item {
    private static final Map<Block, ItemLiquidContainer> buckets = new HashMap<Block, ItemLiquidContainer>();
    private boolean isDrink = false;
    private boolean isAlwaysEdible = false;
    private int healAmount = 0;
    private float saturationModifier = 0.0f;
    private final EnumContainerType type;
    private final Block contents;
    private final Color color;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemLiquidContainer(EnumContainerType type, Block contents, Color color) {
        this.type = type;
        this.contents = contents;
        this.color = color;
        this.setCreativeTab(CreativeTabForestry.tabForestry);
        if (type == EnumContainerType.BUCKET) {
            this.setContainerItem(Items.bucket);
            this.maxStackSize = 1;
            buckets.put(contents, this);
        }
    }

    public static ItemLiquidContainer getExistingBucket(Block contents) {
        return buckets.get(contents);
    }

    private static int getMatchingSlot(EntityPlayer player, ItemStack stack) {
        for (int slot = 0; slot < player.inventory.mainInventory.length; ++slot) {
            int space;
            ItemStack slotStack = player.inventory.getStackInSlot(slot);
            if (slotStack == null) {
                return slot;
            }
            if (!slotStack.isItemEqual(stack) || (space = slotStack.getMaxStackSize() - slotStack.stackSize) < stack.stackSize) continue;
            return slot;
        }
        return -1;
    }

    public ItemStack onEaten(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!this.isDrink) {
            return itemstack;
        }
        --itemstack.stackSize;
        entityplayer.getFoodStats().addStats(this.healAmount, this.saturationModifier);
        world.playSoundAtEntity((Entity)entityplayer, "random.burp", 0.5f, world.rand.nextFloat() * 0.1f + 0.9f);
        return itemstack;
    }

    public int getMaxItemUseDuration(ItemStack itemstack) {
        if (this.isDrink) {
            return 32;
        }
        return super.getMaxItemUseDuration(itemstack);
    }

    public EnumAction getItemUseAction(ItemStack itemstack) {
        if (this.isDrink) {
            return EnumAction.drink;
        }
        return EnumAction.none;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (world.isRemote) {
            return itemstack;
        }
        if (this.isDrink) {
            if (entityplayer.canEat(this.isAlwaysEdible)) {
                entityplayer.setItemInUse(itemstack, this.getMaxItemUseDuration(itemstack));
            }
            return itemstack;
        }
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(world, entityplayer, true);
        if (movingobjectposition != null && movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = movingobjectposition.blockX;
            int y = movingobjectposition.blockY;
            int z = movingobjectposition.blockZ;
            Block targetedBlock = world.getBlock(x, y, z);
            FluidStack fluid = null;
            if (targetedBlock instanceof IFluidBlock) {
                fluid = ((IFluidBlock)targetedBlock).drain(world, x, y, z, false);
            } else if (targetedBlock == Blocks.water || targetedBlock == Blocks.flowing_water) {
                fluid = new FluidStack(FluidRegistry.WATER, 1000);
            } else if (targetedBlock == Blocks.lava || targetedBlock == Blocks.flowing_lava) {
                fluid = new FluidStack(FluidRegistry.LAVA, 1000);
            }
            if (fluid == null || fluid.amount <= 0 && this.type == EnumContainerType.BUCKET) {
                return this.tryPlaceLiquid(itemstack, world, entityplayer, movingobjectposition);
            }
            ItemStack filledContainer = FluidHelper.getFilledContainer(fluid.getFluid(), itemstack);
            if (filledContainer == null) {
                return itemstack;
            }
            int slot = ItemLiquidContainer.getMatchingSlot(entityplayer, filledContainer);
            if (slot < 0) {
                return itemstack;
            }
            if (entityplayer.inventory.getStackInSlot(slot) == null) {
                entityplayer.inventory.setInventorySlotContents(slot, filledContainer.copy());
            } else {
                ++entityplayer.inventory.getStackInSlot((int)slot).stackSize;
            }
            if (targetedBlock instanceof IFluidBlock) {
                ((IFluidBlock)targetedBlock).drain(world, x, y, z, true);
            } else {
                world.setBlockToAir(x, y, z);
            }
            --itemstack.stackSize;
            Proxies.net.inventoryChangeNotify(entityplayer);
            return itemstack;
        }
        return itemstack;
    }

    private ItemStack tryPlaceLiquid(ItemStack itemstack, World world, EntityPlayer player, MovingObjectPosition movingobjectposition) {
        if (this.type != EnumContainerType.BUCKET) {
            return itemstack;
        }
        if (this.contents == Blocks.air) {
            return new ItemStack(Items.bucket);
        }
        int x = movingobjectposition.blockX;
        int y = movingobjectposition.blockY;
        int z = movingobjectposition.blockZ;
        switch (movingobjectposition.sideHit) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        if (!player.canPlayerEdit(x, y, z, movingobjectposition.sideHit, itemstack)) {
            return itemstack;
        }
        if (this.tryPlaceLiquidAtPosition(world, x, y, z) && !player.capabilities.isCreativeMode) {
            return new ItemStack(Items.bucket);
        }
        return itemstack;
    }

    private boolean tryPlaceLiquidAtPosition(World world, int x, int y, int z) {
        boolean isLiquid;
        if (this.contents == Blocks.air) {
            return false;
        }
        Material material = world.getBlock(x, y, z).getMaterial();
        boolean bl = isLiquid = !material.isSolid();
        if (!world.isAirBlock(x, y, z) && !isLiquid) {
            return false;
        }
        if (world.provider.isHellWorld && this.contents != Blocks.flowing_lava) {
            int flammability = this.contents.getFlammability((IBlockAccess)world, x, y, z, ForgeDirection.UNKNOWN);
            if (this.contents instanceof BlockForestryFluid && flammability > 0) {
                float explosionSize = 4.0f * (float)flammability / 300.0f;
                world.newExplosion(null, (double)x, (double)y, (double)z, explosionSize, true, true);
                return true;
            }
            Random random = world.rand;
            world.playSoundEffect((double)x + 0.5, (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.spawnParticle("largesmoke", (double)x + random.nextDouble(), (double)y + random.nextDouble(), (double)z + random.nextDouble(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!world.isRemote && isLiquid && !material.isLiquid()) {
                world.func_147480_a(x, y, z, true);
            }
            world.setBlock(x, y, z, this.contents, 0, 3);
        }
        return true;
    }

    public ItemLiquidContainer setDrink(int healAmount, float saturationModifier) {
        this.isDrink = true;
        this.healAmount = healAmount;
        this.saturationModifier = saturationModifier;
        return this;
    }

    public ItemLiquidContainer setAlwaysEdible() {
        this.isAlwaysEdible = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new IIcon[2];
        this.icons[0] = TextureManager.registerTex(register, "liquids/" + this.type.toString().toLowerCase(Locale.ENGLISH) + ".bottle");
        this.icons[1] = TextureManager.registerTex(register, "liquids/" + this.type.toString().toLowerCase(Locale.ENGLISH) + ".contents");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int i, int j) {
        if (j > 0 && this.color != null) {
            return this.icons[1];
        }
        return this.icons[0];
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public int getColorFromItemStack(ItemStack itemstack, int j) {
        if (j > 0 && this.color != null) {
            return this.color.getRGB() & 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public EnumContainerType getType() {
        return this.type;
    }

    public static enum EnumContainerType {
        GLASS,
        JAR,
        CAN,
        CAPSULE,
        REFRACTORY,
        BUCKET;

    }
}

