/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorSmeltingRecipe {
    private final ItemStack resource;
    private final FluidStack product;
    private final int meltingPoint;

    public FabricatorSmeltingRecipe(ItemStack resource, FluidStack molten, int meltingPoint) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (molten == null) {
            throw new IllegalArgumentException("Molten cannot be null");
        }
        this.resource = resource;
        this.product = molten;
        this.meltingPoint = meltingPoint;
    }

    public boolean matches(FluidStack product) {
        return this.product.isFluidEqual(product);
    }

    public ItemStack getResource() {
        return this.resource;
    }

    public FluidStack getProduct() {
        return this.product;
    }

    public int getMeltingPoint() {
        return this.meltingPoint;
    }
}

