/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.apiculture.IApiaristTracker;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.IPagedInventory;
import forestry.core.gui.buttons.GuiBetterButton;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.network.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.HashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GuiNaturalistInventory
extends GuiForestry<Container, IPagedInventory> {
    private final ISpeciesRoot speciesRoot;
    private final IBreedingTracker breedingTracker;
    private final HashMap<String, ItemStack> iconStacks = new HashMap();
    private final int pageCurrent;
    private final int pageMax;

    public GuiNaturalistInventory(ISpeciesRoot speciesRoot, EntityPlayer player, Container container, IPagedInventory inventory, int page, int maxPages) {
        super("textures/gui/apiaristinventory.png", container, inventory);
        this.speciesRoot = speciesRoot;
        this.pageCurrent = page;
        this.pageMax = maxPages;
        this.xSize = 196;
        this.ySize = 202;
        for (IIndividual iIndividual : speciesRoot.getIndividualTemplates()) {
            this.iconStacks.put(iIndividual.getIdent(), speciesRoot.getMemberStack(iIndividual, 0));
        }
        this.breedingTracker = speciesRoot.getBreedingTracker(player.worldObj, player.getGameProfile());
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        super.drawGuiContainerBackgroundLayer(f, i, j);
        String header = StringUtil.localize("gui.page") + " " + (this.pageCurrent + 1) + "/" + this.pageMax;
        this.fontRendererObj.drawString(header, this.guiLeft + 95 + this.getCenteredOffset(header, 98), this.guiTop + 10, this.fontColor.get("gui.title"));
        IIndividual individual = this.getIndividualAtPosition(i, j);
        if (individual == null) {
            this.displayBreedingStatistics(10);
        }
        if (individual != null) {
            RenderHelper.enableGUIStandardItemLighting();
            this.startPage();
            this.displaySpeciesInformation(true, individual.getGenome().getPrimary(), this.iconStacks.get(individual.getIdent()), 10);
            if (!individual.isPureBred(EnumTreeChromosome.SPECIES)) {
                this.displaySpeciesInformation(individual.isAnalyzed(), individual.getGenome().getSecondary(), this.iconStacks.get(individual.getGenome().getSecondary().getUID()), 10);
            }
            this.endPage();
        }
    }

    public void initGui() {
        super.initGui();
        this.buttonList.add(new GuiBetterButton(1, this.guiLeft + 99, this.guiTop + 7, StandardButtonTextureSets.LEFT_BUTTON_SMALL));
        this.buttonList.add(new GuiBetterButton(2, this.guiLeft + 180, this.guiTop + 7, StandardButtonTextureSets.RIGHT_BUTTON_SMALL));
    }

    private static void flipPage(int page) {
        Proxies.net.sendToServer(new PacketGuiSelectRequest(page, 0));
    }

    protected void actionPerformed(GuiButton guibutton) {
        super.actionPerformed(guibutton);
        if (guibutton.id == 1 && this.pageCurrent > 0) {
            GuiNaturalistInventory.flipPage(this.pageCurrent - 1);
        } else if (guibutton.id == 2 && this.pageCurrent < this.pageMax - 1) {
            GuiNaturalistInventory.flipPage(this.pageCurrent + 1);
        }
    }

    private IIndividual getIndividualAtPosition(int x, int y) {
        Slot slot = this.getSlotAtPosition(x, y);
        if (slot == null) {
            return null;
        }
        if (!slot.getHasStack()) {
            return null;
        }
        if (!slot.getStack().hasTagCompound()) {
            return null;
        }
        if (!this.speciesRoot.isMember(slot.getStack())) {
            return null;
        }
        return this.speciesRoot.getMember(slot.getStack());
    }

    private void displayBreedingStatistics(int x) {
        this.startPage();
        this.drawLine(StringUtil.localize("gui.speciescount") + ": " + this.breedingTracker.getSpeciesBred() + "/" + this.speciesRoot.getSpeciesCount(), x);
        this.newLine();
        this.newLine();
        if (this.breedingTracker instanceof IApiaristTracker) {
            IApiaristTracker tracker = (IApiaristTracker)this.breedingTracker;
            this.drawLine(StringUtil.localize("gui.queens") + ": " + tracker.getQueenCount(), x);
            this.newLine();
            this.drawLine(StringUtil.localize("gui.princesses") + ": " + tracker.getPrincessCount(), x);
            this.newLine();
            this.drawLine(StringUtil.localize("gui.drones") + ": " + tracker.getDroneCount(), x);
            this.newLine();
        }
        this.endPage();
    }

    private void displaySpeciesInformation(boolean analyzed, IAlleleSpecies species, ItemStack iconStack, int x) {
        if (!analyzed) {
            this.drawLine(StringUtil.localize("gui.unknown"), x);
            return;
        }
        this.drawLine(species.getName(), x);
        RenderHelper.enableGUIStandardItemLighting();
        this.drawItemStack(iconStack, this.guiLeft + x + 69, this.guiTop + this.getLineY() - 2);
        RenderHelper.disableStandardItemLighting();
        this.newLine();
        int columnWidth = 16;
        int column = 10;
        for (IMutation iMutation : this.speciesRoot.getCombinations(species)) {
            if (iMutation.isSecret()) continue;
            if (this.breedingTracker.isDiscovered(iMutation)) {
                this.drawMutationIcon(iMutation, species, column);
            } else {
                this.drawUnknownIcon(iMutation, column);
            }
            if ((column += columnWidth) <= 75) continue;
            column = 10;
            this.newLine(18);
        }
        this.newLine();
        this.newLine();
    }

    private void drawMutationIcon(IMutation combination, IAlleleSpecies species, int x) {
        int column;
        RenderHelper.enableGUIStandardItemLighting();
        this.drawItemStack(this.iconStacks.get(combination.getPartner(species).getUID()), this.guiLeft + x, this.guiTop + this.getLineY());
        RenderHelper.disableStandardItemLighting();
        int line = 48;
        EnumMutateChance chance = EnumMutateChance.rateChance(combination.getBaseChance());
        if (chance == EnumMutateChance.HIGHEST) {
            line += 16;
            column = 228;
        } else if (chance == EnumMutateChance.HIGHER) {
            line += 16;
            column = 212;
        } else if (chance == EnumMutateChance.HIGH) {
            line += 16;
            column = 196;
        } else if (chance == EnumMutateChance.NORMAL) {
            line += 0;
            column = 228;
        } else if (chance == EnumMutateChance.LOW) {
            line += 0;
            column = 212;
        } else {
            line += 0;
            column = 196;
        }
        Proxies.render.bindTexture(this.textureFile);
        this.drawTexturedModalRect(this.guiLeft + x, this.guiTop + this.getLineY(), column, line, 16, 16);
    }

    private void drawUnknownIcon(IMutation mutation, int x) {
        int column;
        int line;
        float chance = mutation.getBaseChance();
        if (chance >= 20.0f) {
            line = 16;
            column = 228;
        } else if (chance >= 15.0f) {
            line = 16;
            column = 212;
        } else if (chance >= 12.0f) {
            line = 16;
            column = 196;
        } else if (chance >= 10.0f) {
            line = 0;
            column = 228;
        } else if (chance >= 5.0f) {
            line = 0;
            column = 212;
        } else {
            line = 0;
            column = 196;
        }
        Proxies.render.bindTexture(this.textureFile);
        this.drawTexturedModalRect(this.guiLeft + x, this.guiTop + this.getLineY(), column, line, 16, 16);
    }

    protected boolean checkHotbarKeys(int key) {
        return false;
    }
}

